/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.client;

import io.confluent.ksql.api.client.KsqlArray;
import io.vertx.core.json.JsonObject;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;

public class KsqlObject {
    private final JsonObject delegate;

    public KsqlObject() {
        this.delegate = new JsonObject();
    }

    public KsqlObject(Map<String, Object> map) {
        this.delegate = new JsonObject(map);
    }

    KsqlObject(JsonObject jsonObject) {
        this.delegate = Objects.requireNonNull(jsonObject);
    }

    public boolean containsKey(String key) {
        return this.delegate.containsKey(key);
    }

    public Set<String> fieldNames() {
        return this.delegate.fieldNames();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public Map<String, Object> getMap() {
        return this.delegate.getMap();
    }

    public Iterator<Map.Entry<String, Object>> iterator() {
        return this.delegate.iterator();
    }

    public Stream<Map.Entry<String, Object>> stream() {
        return this.delegate.stream();
    }

    public Object getValue(String key) {
        return this.delegate.getValue(key);
    }

    public String getString(String key) {
        return this.delegate.getString(key);
    }

    public Integer getInteger(String key) {
        return this.delegate.getInteger(key);
    }

    public Long getLong(String key) {
        return this.delegate.getLong(key);
    }

    public Double getDouble(String key) {
        return this.delegate.getDouble(key);
    }

    public Boolean getBoolean(String key) {
        return this.delegate.getBoolean(key);
    }

    public BigDecimal getDecimal(String key) {
        return new BigDecimal(this.getValue(key).toString());
    }

    public byte[] getBytes(String key) {
        return this.delegate.getBinary(key);
    }

    public KsqlArray getKsqlArray(String key) {
        return new KsqlArray(this.delegate.getJsonArray(key));
    }

    public KsqlObject getKsqlObject(String key) {
        return new KsqlObject(this.delegate.getJsonObject(key));
    }

    public Object remove(String key) {
        return this.delegate.remove(key);
    }

    public KsqlObject put(String key, Integer value) {
        this.delegate.put(key, (Object)value);
        return this;
    }

    public KsqlObject put(String key, Long value) {
        this.delegate.put(key, (Object)value);
        return this;
    }

    public KsqlObject put(String key, String value) {
        this.delegate.put(key, (Object)value);
        return this;
    }

    public KsqlObject put(String key, Double value) {
        this.delegate.put(key, (Object)value);
        return this;
    }

    public KsqlObject put(String key, Boolean value) {
        this.delegate.put(key, (Object)value);
        return this;
    }

    public KsqlObject put(String key, BigDecimal value) {
        this.delegate.put(key, (Object)value.toString());
        return this;
    }

    public KsqlObject put(String key, byte[] value) {
        this.delegate.put(key, (Object)value);
        return this;
    }

    public KsqlObject put(String key, KsqlArray value) {
        this.delegate.put(key, (Object)KsqlArray.toJsonArray(value));
        return this;
    }

    public KsqlObject put(String key, KsqlObject value) {
        this.delegate.put(key, (Object)KsqlObject.toJsonObject(value));
        return this;
    }

    public KsqlObject put(String key, Object value) {
        this.delegate.put(key, value);
        return this;
    }

    public KsqlObject putNull(String key) {
        this.delegate.putNull(key);
        return this;
    }

    public KsqlObject mergeIn(KsqlObject other) {
        this.delegate.mergeIn(KsqlObject.toJsonObject(other));
        return this;
    }

    public KsqlObject copy() {
        return new KsqlObject(this.delegate.copy());
    }

    public String toJsonString() {
        return this.delegate.toString();
    }

    public String toString() {
        return this.toJsonString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KsqlObject that = (KsqlObject)o;
        return this.delegate.equals((Object)that.delegate);
    }

    public int hashCode() {
        return Objects.hashCode(this.delegate);
    }

    public static KsqlObject fromArray(List<String> keys, KsqlArray values) {
        if (values == null || keys == null) {
            return null;
        }
        if (keys.size() != values.size()) {
            throw new IllegalArgumentException("Size of keys and values must match.");
        }
        KsqlObject ret = new KsqlObject();
        for (int i = 0; i < keys.size(); ++i) {
            ret.put(keys.get(i), values.getValue(i));
        }
        return ret;
    }

    static JsonObject toJsonObject(KsqlObject ksqlObject) {
        return new JsonObject(ksqlObject.getMap());
    }
}

