/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.client.impl;

import io.confluent.ksql.api.client.QueryInfo;
import io.confluent.ksql.api.client.ServerInfo;
import io.confluent.ksql.api.client.SourceDescription;
import io.confluent.ksql.api.client.StreamInfo;
import io.confluent.ksql.api.client.TableInfo;
import io.confluent.ksql.api.client.TopicInfo;
import io.confluent.ksql.api.client.impl.ColumnTypeImpl;
import io.confluent.ksql.api.client.impl.FieldInfoImpl;
import io.confluent.ksql.api.client.impl.QueryInfoImpl;
import io.confluent.ksql.api.client.impl.ServerInfoImpl;
import io.confluent.ksql.api.client.impl.SourceDescriptionImpl;
import io.confluent.ksql.api.client.impl.StreamInfoImpl;
import io.confluent.ksql.api.client.impl.TableInfoImpl;
import io.confluent.ksql.api.client.impl.TopicInfoImpl;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

final class AdminResponseHandlers {
    private AdminResponseHandlers() {
    }

    static void handleListStreamsResponse(JsonObject streamsListEntity, CompletableFuture<List<StreamInfo>> cf) {
        Optional<List<StreamInfo>> streams = AdminResponseHandlers.getListStreamsResponse(streamsListEntity);
        if (streams.isPresent()) {
            cf.complete(streams.get());
        } else {
            cf.completeExceptionally(new IllegalStateException("Unexpected server response format. Response: " + streamsListEntity));
        }
    }

    static void handleListTablesResponse(JsonObject tablesListEntity, CompletableFuture<List<TableInfo>> cf) {
        Optional<List<TableInfo>> tables = AdminResponseHandlers.getListTablesResponse(tablesListEntity);
        if (tables.isPresent()) {
            cf.complete(tables.get());
        } else {
            cf.completeExceptionally(new IllegalStateException("Unexpected server response format. Response: " + tablesListEntity));
        }
    }

    static void handleListTopicsResponse(JsonObject kafkaTopicsListEntity, CompletableFuture<List<TopicInfo>> cf) {
        Optional<List<TopicInfo>> topics = AdminResponseHandlers.getListTopicsResponse(kafkaTopicsListEntity);
        if (topics.isPresent()) {
            cf.complete(topics.get());
        } else {
            cf.completeExceptionally(new IllegalStateException("Unexpected server response format. Response: " + kafkaTopicsListEntity));
        }
    }

    static void handleListQueriesResponse(JsonObject queriesEntity, CompletableFuture<List<QueryInfo>> cf) {
        Optional<List<QueryInfo>> queries = AdminResponseHandlers.getListQueriesResponse(queriesEntity);
        if (queries.isPresent()) {
            cf.complete(queries.get());
        } else {
            cf.completeExceptionally(new IllegalStateException("Unexpected server response format. Response: " + queriesEntity));
        }
    }

    static void handleDescribeSourceResponse(JsonObject sourceDescriptionEntity, CompletableFuture<SourceDescription> cf) {
        Optional<SourceDescription> source = AdminResponseHandlers.getDescribeSourceResponse(sourceDescriptionEntity);
        if (source.isPresent()) {
            cf.complete(source.get());
        } else {
            cf.completeExceptionally(new IllegalStateException("Unexpected server response format. Response: " + sourceDescriptionEntity));
        }
    }

    static void handleServerInfoResponse(JsonObject serverInfoEntity, CompletableFuture<ServerInfo> cf) {
        JsonObject source = serverInfoEntity.getJsonObject("KsqlServerInfo");
        try {
            ServerInfoImpl serverInfo = new ServerInfoImpl(source.getString("version"), source.getString("kafkaClusterId"), source.getString("ksqlServiceId"));
            cf.complete(serverInfo);
        }
        catch (Exception e) {
            cf.completeExceptionally(new IllegalStateException("Unexpected server response format. Response: " + serverInfoEntity));
        }
    }

    static boolean isListStreamsResponse(JsonObject ksqlEntity) {
        return AdminResponseHandlers.getListStreamsResponse(ksqlEntity).isPresent();
    }

    static boolean isListTablesResponse(JsonObject ksqlEntity) {
        return AdminResponseHandlers.getListTablesResponse(ksqlEntity).isPresent();
    }

    static boolean isListTopicsResponse(JsonObject ksqlEntity) {
        return AdminResponseHandlers.getListTopicsResponse(ksqlEntity).isPresent();
    }

    static boolean isListQueriesResponse(JsonObject ksqlEntity) {
        return AdminResponseHandlers.getListQueriesResponse(ksqlEntity).isPresent();
    }

    static boolean isDescribeSourceResponse(JsonObject ksqlEntity) {
        return AdminResponseHandlers.getDescribeSourceResponse(ksqlEntity).isPresent();
    }

    static boolean isDescribeOrListFunctionResponse(JsonObject ksqlEntity) {
        return ksqlEntity.getJsonArray("functions") != null;
    }

    static boolean isExplainQueryResponse(JsonObject ksqlEntity) {
        return ksqlEntity.getJsonObject("queryDescription") != null;
    }

    static boolean isListPropertiesResponse(JsonObject ksqlEntity) {
        return ksqlEntity.getJsonArray("properties") != null;
    }

    static boolean isListTypesResponse(JsonObject ksqlEntity) {
        return ksqlEntity.getJsonObject("types") != null;
    }

    static boolean isListConnectorsResponse(JsonObject ksqlEntity) {
        return ksqlEntity.getJsonArray("connectors") != null;
    }

    static boolean isDescribeConnectorResponse(JsonObject ksqlEntity) {
        return ksqlEntity.getString("connectorClass") != null;
    }

    static boolean isCreateConnectorResponse(JsonObject ksqlEntity) {
        return ksqlEntity.getJsonObject("info") != null || ksqlEntity.getString("message") != null && ksqlEntity.getString("message").contains("already exists");
    }

    static boolean isDropConnectorResponse(JsonObject ksqlEntity) {
        return ksqlEntity.getString("connectorName") != null || ksqlEntity.getString("message") != null && ksqlEntity.getString("message").contains("not exist");
    }

    static boolean isConnectErrorResponse(JsonObject ksqlEntity) {
        return ksqlEntity.getString("errorMessage") != null;
    }

    private static Optional<List<StreamInfo>> getListStreamsResponse(JsonObject streamsListEntity) {
        try {
            JsonArray streams = streamsListEntity.getJsonArray("streams");
            return Optional.of(streams.stream().map(o -> (JsonObject)o).map(o -> new StreamInfoImpl(o.getString("name"), o.getString("topic"), o.getString("keyFormat", "KAFKA"), o.getString("valueFormat", o.getString("format", "UNKNOWN")), o.getBoolean("isWindowed", Boolean.valueOf(false)))).collect(Collectors.toList()));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private static Optional<List<TableInfo>> getListTablesResponse(JsonObject tablesListEntity) {
        try {
            JsonArray tables = tablesListEntity.getJsonArray("tables");
            return Optional.of(tables.stream().map(o -> (JsonObject)o).map(o -> new TableInfoImpl(o.getString("name"), o.getString("topic"), o.getString("keyFormat", "KAFKA"), o.getString("valueFormat", o.getString("format", "UNKNOWN")), o.getBoolean("isWindowed"))).collect(Collectors.toList()));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private static Optional<List<TopicInfo>> getListTopicsResponse(JsonObject kafkaTopicsListEntity) {
        try {
            JsonArray topics = kafkaTopicsListEntity.getJsonArray("topics");
            return Optional.of(topics.stream().map(o -> (JsonObject)o).map(o -> {
                List<Integer> replicaInfo = o.getJsonArray("replicaInfo").stream().map(v -> (Integer)v).collect(Collectors.toList());
                return new TopicInfoImpl(o.getString("name"), replicaInfo.size(), replicaInfo);
            }).collect(Collectors.toList()));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private static Optional<List<QueryInfo>> getListQueriesResponse(JsonObject queriesEntity) {
        try {
            JsonArray queries = queriesEntity.getJsonArray("queries");
            return Optional.of(AdminResponseHandlers.formatQueries(queries));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private static List<QueryInfo> formatQueries(JsonArray queries) {
        return queries.stream().map(o -> (JsonObject)o).map(o -> {
            Optional<String> sinkTopicName;
            Optional<String> sinkName;
            QueryInfo.QueryType queryType = QueryInfo.QueryType.valueOf(o.getString("queryType"));
            JsonArray sinks = o.getJsonArray("sinks");
            JsonArray sinkTopics = o.getJsonArray("sinkKafkaTopics");
            if (queryType == QueryInfo.QueryType.PERSISTENT) {
                if (sinks.size() != 1 || sinkTopics.size() != 1) {
                    throw new IllegalStateException("Persistent queries must have exactly one sink.");
                }
                sinkName = Optional.of(sinks.getString(0));
                sinkTopicName = Optional.of(sinkTopics.getString(0));
            } else if (queryType == QueryInfo.QueryType.PUSH) {
                if (sinks.size() != 0 || sinkTopics.size() != 0) {
                    throw new IllegalStateException("Push queries must have no sinks.");
                }
                sinkName = Optional.empty();
                sinkTopicName = Optional.empty();
            } else {
                throw new IllegalStateException("Unexpected query type.");
            }
            return new QueryInfoImpl(queryType, o.getString("id"), o.getString("queryString"), sinkName, sinkTopicName);
        }).collect(Collectors.toList());
    }

    private static Optional<SourceDescription> getDescribeSourceResponse(JsonObject sourceDescriptionEntity) {
        try {
            JsonObject source = sourceDescriptionEntity.getJsonObject("sourceDescription");
            return Optional.of(new SourceDescriptionImpl(source.getString("name"), source.getString("type"), source.getJsonArray("fields").stream().map(o -> (JsonObject)o).map(f -> new FieldInfoImpl(f.getString("name"), new ColumnTypeImpl(f.getJsonObject("schema").getString("type")), "KEY".equals(f.getString("type")))).collect(Collectors.toList()), source.getString("topic"), source.getString("keyFormat"), source.getString("valueFormat"), AdminResponseHandlers.formatQueries(source.getJsonArray("readQueries")), AdminResponseHandlers.formatQueries(source.getJsonArray("writeQueries")), Optional.ofNullable(AdminResponseHandlers.emptyToNull(source.getString("timestamp"))), Optional.ofNullable(AdminResponseHandlers.emptyToNull(source.getString("windowType"))), source.getString("statement"), source.getJsonArray("sourceConstraints", new JsonArray()).stream().map(o -> (String)o).collect(Collectors.toList())));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private static String emptyToNull(String str) {
        return str == null ? null : (str.isEmpty() ? null : str);
    }
}

