/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.client.impl;

import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.api.client.ConnectorDescription;
import io.confluent.ksql.api.client.ConnectorType;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ConnectorDescriptionImpl
implements ConnectorDescription {
    private final String name;
    private final String className;
    private final ImmutableList<String> sources;
    private final ImmutableList<String> topics;
    private final ConnectorType type;
    private final String state;

    public ConnectorDescriptionImpl(String name, String className, List<String> sources, List<String> topics, ConnectorType type, String state) {
        this.name = Objects.requireNonNull(name, "name");
        this.className = Objects.requireNonNull(className, "className");
        this.sources = ImmutableList.copyOf((Collection)Objects.requireNonNull(sources, "sources"));
        this.topics = ImmutableList.copyOf((Collection)Objects.requireNonNull(topics, "topics"));
        this.type = Objects.requireNonNull(type, "type");
        this.state = Objects.requireNonNull(state, "state");
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="sources is ImmutableList")
    public List<String> sources() {
        return this.sources;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="topics is ImmutableList")
    public List<String> topics() {
        return this.topics;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ConnectorType type() {
        return this.type;
    }

    @Override
    public String className() {
        return this.className;
    }

    @Override
    public String state() {
        return this.state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectorDescriptionImpl connectorDescription = (ConnectorDescriptionImpl)o;
        return this.name.equals(connectorDescription.name) && this.className.equals(connectorDescription.className) && this.sources.equals(connectorDescription.sources) && this.topics.equals(connectorDescription.topics) && this.type.equals(connectorDescription.type) && this.state.equals(connectorDescription.state);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.sources, this.topics, this.type, this.state);
    }

    public String toString() {
        return "ConnectorDescription{name='" + this.name + '\'' + "className='" + this.className + '\'' + ", sources=" + this.sources + ", topics=" + this.topics + ", type=" + this.type + ", state=" + this.state + '}';
    }
}

