/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.client.util;

import io.confluent.ksql.api.client.ColumnType;
import io.confluent.ksql.api.client.impl.ColumnTypeImpl;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class RowUtil {
    private RowUtil() {
    }

    public static Map<String, Integer> valueToIndexMap(List<String> values) {
        HashMap<String, Integer> valueToIndex = new HashMap<String, Integer>();
        for (int i = 0; i < values.size(); ++i) {
            valueToIndex.put(values.get(i), i + 1);
        }
        return valueToIndex;
    }

    public static List<ColumnType> columnTypesFromStrings(List<String> columnTypes) {
        return columnTypes.stream().map(RowUtil::columnTypeFromString).collect(Collectors.toList());
    }

    private static ColumnType columnTypeFromString(String columnType) {
        int bracketInd = columnType.indexOf(60);
        int parenInd = columnType.indexOf(40);
        String primaryType = columnType.substring(0, Math.min(bracketInd == -1 ? columnType.length() : bracketInd, parenInd == -1 ? columnType.length() : parenInd));
        return new ColumnTypeImpl(primaryType);
    }

    public static List<String> colNamesFromSchema(String schema) {
        return RowUtil.splitAcrossOneLevelDeepComma(schema).stream().map(RowUtil::removeBackTickAndKeyTrim).map(RowUtil::splitAndGetFirst).collect(Collectors.toList());
    }

    public static List<String> colTypesFromSchema(String schema) {
        return RowUtil.splitAcrossOneLevelDeepComma(schema).stream().map(RowUtil::removeBackTickAndKeyTrim).map(RowUtil::splitAndGetSecond).collect(Collectors.toList());
    }

    /*
     * Enabled aggressive block sorting
     */
    private static List<String> splitAcrossOneLevelDeepComma(String stringWithCommas) {
        LinkedList<String> listCols = new LinkedList<String>();
        StringBuilder sb = new StringBuilder();
        int nestRound = 0;
        int nestChevron = 0;
        int i = 0;
        while (i < stringWithCommas.length()) {
            block9: {
                char ch = stringWithCommas.charAt(i);
                if (i == stringWithCommas.length() - 1) {
                    sb.append(ch);
                    listCols.add(sb.toString());
                    return listCols;
                }
                switch (ch) {
                    case ',': {
                        if (nestRound != 0 || nestChevron != 0) break;
                        listCols.add(sb.toString());
                        sb.setLength(0);
                        break block9;
                    }
                    case '(': {
                        ++nestRound;
                        break;
                    }
                    case ')': {
                        --nestRound;
                        break;
                    }
                    case '<': {
                        ++nestChevron;
                        break;
                    }
                    case '>': {
                        --nestChevron;
                    }
                }
                sb.append(ch);
            }
            ++i;
        }
        return listCols;
    }

    private static String removeBackTickAndKeyTrim(String dirtyString) {
        return dirtyString.replace(" KEY", "").replace("`", "").trim();
    }

    private static String splitAndGetFirst(String stringToSplit) {
        return stringToSplit.split(" ", 2)[0];
    }

    private static String splitAndGetSecond(String stringToSplit) {
        return stringToSplit.split(" ", 2)[1];
    }
}

