/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.generic;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.group.Group;
import org.apache.kafka.coordinator.group.generic.GenericGroupMember;
import org.apache.kafka.coordinator.group.generic.GenericGroupState;
import org.apache.kafka.coordinator.group.generic.Protocol;
import org.slf4j.Logger;

public class GenericGroup
implements Group {
    public static final int NO_GENERATION = -1;
    public static final String NO_PROTOCOL_NAME = "";
    public static final String NO_LEADER = "";
    private static final String MEMBER_ID_DELIMITER = "-";
    private final Logger log;
    private final String groupId;
    private final Time time;
    private GenericGroupState state;
    private Optional<Long> currentStateTimestamp;
    private Optional<String> protocolType = Optional.empty();
    private Optional<String> protocolName = Optional.empty();
    private int generationId = 0;
    private Optional<String> leaderId = Optional.empty();
    private final Map<String, GenericGroupMember> members = new HashMap<String, GenericGroupMember>();
    private final Map<String, String> staticMembers = new HashMap<String, String>();
    private final Set<String> pendingJoinMembers = new HashSet<String>();
    private int numMembersAwaitingJoinResponse = 0;
    private final Map<String, Integer> supportedProtocols = new HashMap<String, Integer>();
    private final Set<String> pendingSyncMembers = new HashSet<String>();
    private Optional<Set<String>> subscribedTopics = Optional.empty();
    private boolean newMemberAdded = false;

    public GenericGroup(LogContext logContext, String groupId, GenericGroupState initialState, Time time) {
        Objects.requireNonNull(logContext);
        this.log = logContext.logger(GenericGroup.class);
        this.groupId = Objects.requireNonNull(groupId);
        this.state = Objects.requireNonNull(initialState);
        this.time = Objects.requireNonNull(time);
        this.currentStateTimestamp = Optional.of(time.milliseconds());
    }

    @Override
    public Group.GroupType type() {
        return Group.GroupType.GENERIC;
    }

    @Override
    public String stateAsString() {
        return this.state.toString();
    }

    @Override
    public String groupId() {
        return this.groupId;
    }

    public int generationId() {
        return this.generationId;
    }

    public Optional<String> protocolName() {
        return this.protocolName;
    }

    public Optional<String> protocolType() {
        return this.protocolType;
    }

    public GenericGroupState currentState() {
        return this.state;
    }

    public boolean isInState(GenericGroupState groupState) {
        return this.state == groupState;
    }

    public boolean hasMemberId(String memberId) {
        return this.members.containsKey(memberId);
    }

    public GenericGroupMember member(String memberId) {
        return this.members.get(memberId);
    }

    public int size() {
        return this.members.size();
    }

    public boolean isLeader(String memberId) {
        return this.leaderId.map(id -> id.equals(memberId)).orElse(false);
    }

    public String leaderOrNull() {
        return this.leaderId.orElse(null);
    }

    public long currentStateTimestampOrDefault() {
        return this.currentStateTimestamp.orElse(-1L);
    }

    public boolean usesConsumerGroupProtocol() {
        return this.protocolType.map(type -> type.equals("consumer")).orElse(false);
    }

    public void add(GenericGroupMember member) {
        this.add(member, null);
    }

    public void add(GenericGroupMember member, CompletableFuture<JoinGroupResponseData> future) {
        member.groupInstanceId().ifPresent(instanceId -> {
            if (this.staticMembers.containsKey(instanceId)) {
                throw new IllegalStateException("Static member with groupInstanceId=" + instanceId + " cannot be added to group " + this.groupId + " since it is already a member.");
            }
            this.staticMembers.put((String)instanceId, member.memberId());
        });
        if (this.members.isEmpty()) {
            this.protocolType = Optional.of(member.protocolType());
        }
        if (!Objects.equals(this.protocolType.orElse(null), member.protocolType())) {
            throw new IllegalStateException("The group and member's protocol type must be the same.");
        }
        if (!this.supportsProtocols(member)) {
            throw new IllegalStateException("None of the member's protocols can be supported.");
        }
        if (!this.leaderId.isPresent()) {
            this.leaderId = Optional.of(member.memberId());
        }
        this.members.put(member.memberId(), member);
        this.incrementSupportedProtocols(member);
        member.setAwaitingJoinFuture(future);
        if (member.isAwaitingJoin()) {
            ++this.numMembersAwaitingJoinResponse;
        }
        this.pendingJoinMembers.remove(member.memberId());
    }

    public void remove(String memberId) {
        GenericGroupMember removedMember = this.members.remove(memberId);
        if (removedMember != null) {
            this.decrementSupportedProtocols(removedMember);
            if (removedMember.isAwaitingJoin()) {
                --this.numMembersAwaitingJoinResponse;
            }
            removedMember.groupInstanceId().ifPresent(this.staticMembers::remove);
        }
        if (this.isLeader(memberId)) {
            Iterator<String> iter = this.members.keySet().iterator();
            String newLeader = iter.hasNext() ? iter.next() : null;
            this.leaderId = Optional.ofNullable(newLeader);
        }
        this.pendingJoinMembers.remove(memberId);
        this.pendingSyncMembers.remove(memberId);
    }

    public boolean maybeElectNewJoinedLeader() {
        if (this.leaderId.isPresent()) {
            GenericGroupMember currentLeader = this.member(this.leaderId.get());
            if (!currentLeader.isAwaitingJoin()) {
                for (GenericGroupMember member : this.members.values()) {
                    if (!member.isAwaitingJoin()) continue;
                    this.leaderId = Optional.of(member.memberId());
                    this.log.info("Group leader [memberId: {}, groupInstanceId: {}] failed to join before the rebalance timeout. Member {} was elected as the new leader.", new Object[]{currentLeader.memberId(), currentLeader.groupInstanceId().orElse("None"), member});
                    return true;
                }
                this.log.info("Group leader [memberId: {}, groupInstanceId: {}] failed to join before the rebalance timeout and the group couldn't proceed to the next generation because no member joined.", (Object)currentLeader.memberId(), (Object)currentLeader.groupInstanceId().orElse("None"));
                return false;
            }
            return true;
        }
        return false;
    }

    public GenericGroupMember replaceStaticMember(String groupInstanceId, String oldMemberId, String newMemberId) {
        GenericGroupMember removedMember = this.members.remove(oldMemberId);
        if (removedMember == null) {
            throw new IllegalArgumentException("Cannot replace non-existing member id " + oldMemberId);
        }
        JoinGroupResponseData joinGroupResponse = new JoinGroupResponseData().setMembers(Collections.emptyList()).setMemberId(oldMemberId).setGenerationId(-1).setProtocolName(null).setProtocolType(null).setLeader("").setSkipAssignment(false).setErrorCode(Errors.FENCED_INSTANCE_ID.code());
        this.completeJoinFuture(removedMember, joinGroupResponse);
        SyncGroupResponseData syncGroupResponse = new SyncGroupResponseData().setAssignment(new byte[0]).setProtocolName(null).setProtocolType(null).setErrorCode(Errors.FENCED_INSTANCE_ID.code());
        this.completeSyncFuture(removedMember, syncGroupResponse);
        GenericGroupMember newMember = new GenericGroupMember(newMemberId, removedMember.groupInstanceId(), removedMember.clientId(), removedMember.clientHost(), removedMember.rebalanceTimeoutMs(), removedMember.sessionTimeoutMs(), removedMember.protocolType(), removedMember.supportedProtocols(), removedMember.assignment());
        this.members.put(newMemberId, newMember);
        if (this.isLeader(oldMemberId)) {
            this.leaderId = Optional.of(newMemberId);
        }
        this.staticMembers.put(groupInstanceId, newMemberId);
        return removedMember;
    }

    public boolean isPendingMember(String memberId) {
        return this.pendingJoinMembers.contains(memberId);
    }

    public boolean addPendingMember(String memberId) {
        if (this.hasMemberId(memberId)) {
            throw new IllegalStateException("Attept to add pending member " + memberId + " which is already a stable member of the group.");
        }
        return this.pendingJoinMembers.add(memberId);
    }

    public int numPending() {
        return this.pendingJoinMembers.size();
    }

    public boolean addPendingSyncMember(String memberId) {
        if (!this.hasMemberId(memberId)) {
            throw new IllegalStateException("Attept to add pending sync member " + memberId + " which is already a stable member of the group.");
        }
        return this.pendingSyncMembers.add(memberId);
    }

    public boolean removePendingSyncMember(String memberId) {
        if (!this.hasMemberId(memberId)) {
            throw new IllegalStateException("Attept to add pending member " + memberId + " which is already a stable member of the group.");
        }
        return this.pendingSyncMembers.remove(memberId);
    }

    public boolean hasReceivedSyncFromAllMembers() {
        return this.pendingSyncMembers.isEmpty();
    }

    public Set<String> allPendingSyncMembers() {
        return this.pendingSyncMembers;
    }

    public void clearPendingSyncMembers() {
        this.pendingSyncMembers.clear();
    }

    public boolean hasStaticMember(String groupInstanceId) {
        return this.staticMembers.containsKey(groupInstanceId);
    }

    public String staticMemberId(String groupInstanceId) {
        return this.staticMembers.get(groupInstanceId);
    }

    public Map<String, GenericGroupMember> notYetRejoinedMembers() {
        HashMap<String, GenericGroupMember> notYetRejoinedMembers = new HashMap<String, GenericGroupMember>();
        this.members.values().forEach(member -> {
            if (!member.isAwaitingJoin()) {
                notYetRejoinedMembers.put(member.memberId(), (GenericGroupMember)member);
            }
        });
        return notYetRejoinedMembers;
    }

    public boolean hasAllMembersJoined() {
        return this.members.size() == this.numMembersAwaitingJoinResponse && this.pendingJoinMembers.isEmpty();
    }

    public Set<String> allMemberIds() {
        return this.members.keySet();
    }

    public Set<String> allStaticMemberIds() {
        return this.staticMembers.keySet();
    }

    Set<String> allDynamicMemberIds() {
        HashSet<String> dynamicMemberSet = new HashSet<String>(this.allMemberIds());
        this.staticMembers.values().forEach(dynamicMemberSet::remove);
        return dynamicMemberSet;
    }

    public int numAwaitingJoinResponse() {
        return this.numMembersAwaitingJoinResponse;
    }

    public Collection<GenericGroupMember> allMembers() {
        return this.members.values();
    }

    public int rebalanceTimeoutMs() {
        int maxRebalanceTimeoutMs = 0;
        for (GenericGroupMember member : this.members.values()) {
            maxRebalanceTimeoutMs = Math.max(maxRebalanceTimeoutMs, member.rebalanceTimeoutMs());
        }
        return maxRebalanceTimeoutMs;
    }

    public String generateMemberId(String clientId, Optional<String> groupInstanceId) {
        return groupInstanceId.map(s -> s + MEMBER_ID_DELIMITER + UUID.randomUUID()).orElseGet(() -> clientId + MEMBER_ID_DELIMITER + UUID.randomUUID());
    }

    public boolean isStaticMemberFenced(String groupInstanceId, String memberId) {
        String existingMemberId = this.staticMemberId(groupInstanceId);
        return existingMemberId != null && !existingMemberId.equals(memberId);
    }

    public boolean canRebalance() {
        return GenericGroupState.PREPARING_REBALANCE.validPreviousStates().contains((Object)this.state);
    }

    public void transitionTo(GenericGroupState groupState) {
        this.assertValidTransition(groupState);
        this.state = groupState;
        this.currentStateTimestamp = Optional.of(this.time.milliseconds());
    }

    public String selectProtocol() {
        if (this.members.isEmpty()) {
            throw new IllegalStateException("Cannot select protocol for empty group");
        }
        Set<String> candidates = this.candidateProtocols();
        HashMap votesByProtocol = new HashMap();
        this.allMembers().stream().map(member -> member.vote(candidates)).forEach(protocolName -> {
            int count = votesByProtocol.getOrDefault(protocolName, 0);
            votesByProtocol.put(protocolName, count + 1);
        });
        return votesByProtocol.entrySet().stream().max(Comparator.comparingInt(Map.Entry::getValue)).map(Map.Entry::getKey).orElse(null);
    }

    private void incrementSupportedProtocols(GenericGroupMember member) {
        member.supportedProtocols().forEach(protocol -> {
            int count = this.supportedProtocols.getOrDefault(protocol.name(), 0);
            this.supportedProtocols.put(protocol.name(), count + 1);
        });
    }

    private void decrementSupportedProtocols(GenericGroupMember member) {
        member.supportedProtocols().forEach(protocol -> {
            int count = this.supportedProtocols.getOrDefault(protocol.name(), 0);
            this.supportedProtocols.put(protocol.name(), count - 1);
        });
    }

    private Set<String> candidateProtocols() {
        return this.supportedProtocols.entrySet().stream().filter(protocol -> ((Integer)protocol.getValue()).intValue() == this.members.size()).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public boolean supportsProtocols(GenericGroupMember member) {
        return this.supportsProtocols(member.protocolType(), GenericGroupMember.plainProtocolSet(member.supportedProtocols()));
    }

    public boolean supportsProtocols(String memberProtocolType, Set<String> memberProtocols) {
        if (this.isInState(GenericGroupState.EMPTY)) {
            return !memberProtocolType.isEmpty() && !memberProtocols.isEmpty();
        }
        return this.protocolType.map(type -> type.equals(memberProtocolType)).orElse(false) != false && memberProtocols.stream().anyMatch(name -> this.supportedProtocols.getOrDefault(name, 0).intValue() == this.members.size());
    }

    public Optional<Set<String>> subscribedTopics() {
        return this.subscribedTopics;
    }

    public boolean isSubscribedToTopic(String topic) {
        return this.subscribedTopics.map(topics -> topics.contains(topic)).orElse(true);
    }

    Optional<Set<String>> computeSubscribedTopics() {
        if (!this.protocolType.isPresent()) {
            return Optional.empty();
        }
        String type = this.protocolType.get();
        if (!type.equals("consumer")) {
            return Optional.empty();
        }
        if (this.members.isEmpty()) {
            return Optional.of(Collections.emptySet());
        }
        if (this.protocolName.isPresent()) {
            try {
                HashSet allSubscribedTopics = new HashSet();
                this.members.values().forEach(member -> {
                    ByteBuffer buffer = ByteBuffer.wrap(member.metadata(this.protocolName.get()));
                    ConsumerProtocol.deserializeVersion((ByteBuffer)buffer);
                    allSubscribedTopics.addAll(new HashSet(ConsumerProtocol.deserializeSubscription((ByteBuffer)buffer, (short)0).topics()));
                });
                return Optional.of(allSubscribedTopics);
            }
            catch (SchemaException e) {
                this.log.warn("Failed to parse Consumer Protocol consumer:" + this.protocolName.get() + " of group " + this.groupId + ". Consumer group coordinator is not aware of the subscribed topics.", (Throwable)e);
            }
        }
        return Optional.empty();
    }

    public void updateMember(GenericGroupMember member, List<Protocol> protocols, int rebalanceTimeoutMs, int sessionTimeoutMs, CompletableFuture<JoinGroupResponseData> future) {
        this.decrementSupportedProtocols(member);
        member.setSupportedProtocols(protocols);
        this.incrementSupportedProtocols(member);
        member.setRebalanceTimeoutMs(rebalanceTimeoutMs);
        member.setSessionTimeoutMs(sessionTimeoutMs);
        if (future != null && !member.isAwaitingJoin()) {
            ++this.numMembersAwaitingJoinResponse;
        } else if (future == null && member.isAwaitingJoin()) {
            --this.numMembersAwaitingJoinResponse;
        }
        member.setAwaitingJoinFuture(future);
    }

    public boolean completeJoinFuture(GenericGroupMember member, JoinGroupResponseData response) {
        if (member.isAwaitingJoin()) {
            member.awaitingJoinFuture().complete(response);
            member.setAwaitingJoinFuture(null);
            --this.numMembersAwaitingJoinResponse;
            return true;
        }
        return false;
    }

    public boolean completeSyncFuture(GenericGroupMember member, SyncGroupResponseData response) {
        if (member.isAwaitingSync()) {
            member.awaitingSyncFuture().complete(response);
            member.setAwaitingSyncFuture(null);
            return true;
        }
        return false;
    }

    public void initNextGeneration() {
        ++this.generationId;
        if (!this.members.isEmpty()) {
            this.protocolName = Optional.of(this.selectProtocol());
            this.subscribedTopics = this.computeSubscribedTopics();
            this.transitionTo(GenericGroupState.COMPLETING_REBALANCE);
        } else {
            this.protocolName = Optional.empty();
            this.subscribedTopics = this.computeSubscribedTopics();
            this.transitionTo(GenericGroupState.EMPTY);
        }
        this.clearPendingSyncMembers();
    }

    public List<JoinGroupResponseData.JoinGroupResponseMember> currentGenericGroupMembers() {
        if (this.isInState(GenericGroupState.DEAD) || this.isInState(GenericGroupState.PREPARING_REBALANCE)) {
            throw new IllegalStateException("Cannot obtain generic member metadata for group " + this.groupId + " in state " + (Object)((Object)this.state));
        }
        return this.members.values().stream().map(member -> new JoinGroupResponseData.JoinGroupResponseMember().setMemberId(member.memberId()).setGroupInstanceId((String)member.groupInstanceId().orElse(null)).setMetadata(member.metadata(this.protocolName.orElse(null)))).collect(Collectors.toList());
    }

    public ListGroupsResponseData.ListedGroup asListedGroup() {
        return new ListGroupsResponseData.ListedGroup().setGroupId(this.groupId).setProtocolType(this.protocolType.orElse("")).setGroupState(this.state.toString());
    }

    private void assertValidTransition(GenericGroupState targetState) {
        if (!targetState.validPreviousStates().contains((Object)this.state)) {
            throw new IllegalStateException("Group " + this.groupId + " should be in one of " + targetState.validPreviousStates() + " states before moving to " + (Object)((Object)targetState) + " state. Instead it is in " + (Object)((Object)this.state) + " state.");
        }
    }

    public String toString() {
        return "GenericGroupMetadata(groupId=" + this.groupId + ", generation=" + this.generationId + ", protocolType=" + this.protocolType + ", currentState=" + (Object)((Object)this.currentState()) + ", members=" + this.members + ")";
    }
}

