/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.databalancing;

public enum CompareResult {
    LESS,
    EQUAL,
    GREATER;


    public boolean isGreater() {
        return this == GREATER;
    }

    public boolean isLess() {
        return this == LESS;
    }

    public boolean isEqual() {
        return this == EQUAL;
    }

    public boolean isGreaterOrEqual() {
        return this.isGreater() || this.isEqual();
    }

    public boolean isLessOrEqual() {
        return this.isLess() || this.isEqual();
    }

    public static CompareResult fromInt(int value) {
        switch (value) {
            case -1: {
                return LESS;
            }
            case 0: {
                return EQUAL;
            }
            case 1: {
                return GREATER;
            }
        }
        throw new IllegalArgumentException("value should be one of -1, 0, 1, but it is: " + value);
    }
}

