/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.databalancing;

import io.confluent.kafka.databalancing.MutableRebalanceContext;
import io.confluent.kafka.databalancing.topology.ClusterAssignment;

public interface RebalancePolicy {
    public ClusterAssignment enforcePlacementConstraints(MutableRebalanceContext var1);

    public ClusterAssignment rebalancePartitions(MutableRebalanceContext var1);

    public static class Config {
        private final Double minFreeVolumeSpacePercentage;

        public Config(Double minFreeVolumeSpacePercentage) {
            if (minFreeVolumeSpacePercentage != null && (minFreeVolumeSpacePercentage < 0.0 || minFreeVolumeSpacePercentage > 100.0)) {
                throw new IllegalArgumentException("minFreeVolumeSpacePercentage should either be null or greater than or equal to 0 and less than or equal to 100");
            }
            this.minFreeVolumeSpacePercentage = minFreeVolumeSpacePercentage;
        }

        public Double minFreeVolumeSpacePercentage() {
            return this.minFreeVolumeSpacePercentage;
        }

        public boolean hasMinFreeVolumeSpace() {
            return this.minFreeVolumeSpacePercentage != null;
        }

        public String toString() {
            return "Config(minFreeVolumeSpacePercentage=" + this.minFreeVolumeSpacePercentage + ')';
        }
    }
}

