/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.databalancing;

import io.confluent.common.config.ConfigUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.types.Password;

public class RebalancerConfig
extends AbstractConfig {
    public static final String BASE_PREFIX = "confluent.rebalancer.";
    public static final String METRICS_PREFIX = "confluent.rebalancer.metrics.";
    public static final String METRICS_BOOTSTRAP_SERVERS_CONFIG = "confluent.rebalancer.metrics.bootstrap.servers";
    public static final String METRICS_BOOTSTRAP_SERVERS_DEFAULT = "";
    protected static final String METRICS_BOOTSTRAP_SERVERS_DOC = "The kafka brokers where the metrics reporter publishes cluster level metrics to. These metrics are needed to make decisions about where to place cluster data.";
    public static final String METRICS_TOPIC_CONFIG = "confluent.rebalancer.metrics.topic";
    public static final String METRICS_TOPIC_DEFAULT = "_confluent-metrics";
    protected static final String METRICS_TOPIC_DOC = "The topic where the metrics reporter publishes its metrics to";
    public static final String METRICS_COLLECTION_TIMEOUT_MS_CONFIG = "confluent.rebalancer.metrics.collection.timeout.ms";
    public static final int METRICS_COLLECTION_TIMEOUT_MS_DEFAULT = 60000;
    protected static final String METRICS_COLLECTION_TIMEOUT_MS_DOC = "The maximum amount of time the rebalancer will collect metrics for. If the collection does not succeed before the timeout elapses, the rebalance command will fail.";
    public static final String CONFLUENT_LICENSE_CONFIG = "confluent.license";
    public static final String CONFLUENT_LICENSE_DEFAULT = "";
    protected static final String CONFLUENT_LICENSE_DOC = "Confluent will issue a license key to each subscriber. The license key will be a short snippet of text that you can copy and paste. Without the license key, you can use the Confluent Rebalancer for a 30-day trial period. If you are a subscriber and don't have a license key, please contact Confluent Support at support@confluent.io.";
    public static final String CONFLUENT_LICENSE_TOPIC_CONFIG = "confluent.license.topic";
    public static final String CONFLUENT_LICENSE_TOPIC_DEFAULT = "_confluent-license";
    public static final String CONFLUENT_LICENSE_TOPIC_DOC = "Name of the Kafka topic used for Confluent Platform configuration, including licensing information.";
    public static final String CONFLUENT_LICENSE_PREFIX = "confluent.license.";
    public static final String CONFLUENT_LICENSE_TOPIC_PREFIX = "confluent.license.topic.";
    public static final String CONFLUENT_LICENSE_PRODUCER_PREFIX = "confluent.license.producer.";
    public static final String CONFLUENT_LICENSE_CONSUMER_PREFIX = "confluent.license.consumer.";
    public static final String CONFLUENT_LICENSE_BOOTSTRAP_SERVERS_CONFIG = "confluent.license.bootstrap.servers";
    public static final String CONFLUENT_LICENSE_BOOTSTRAP_SERVERS_DEFAULT = "";
    public static final String CONFLUENT_LICENSE_BOOTSTRAP_SERVERS_DOC = "A list of host/port pairs to use for establishing the initial connection to the Kafka cluster used for licensing. All servers in the cluster will be discovered from the initial connection. This list should be in the form <code>host1:port1,host2:port2,...</code>. Since these servers are just used for the initial connection to discover the full cluster membership (which may change dynamically), this list need not contain the full set of servers (you may want more than one, though, in case a server is down).";
    public static final String CONFLUENT_LICENSE_TOPIC_REPLICATION_FACTOR_CONFIG = "confluent.license.topic.replication.factor";
    public static final String CONFLUENT_LICENSE_TOPIC_REPLICATION_FACTOR_DOC = "The replication factor for the Kafka topic used for Confluent Platform configuration, including licensing information. This is used only if the topic does not already exist, and the default of 3 is appropriate for production use. If you are using a development environment with less than 3 brokers, you must set this to the number of brokers (often 1).";
    public static final int CONFLUENT_LICENSE_TOPIC_REPLICATION_FACTOR_DEFAULT = 3;
    public static final String MIN_FREE_VOLUME_SPACE_PERCENTAGE_CONFIG = "confluent.rebalancer.min.free.volume.space.percentage";
    public static final double MIN_FREE_VOLUME_SPACE_PERCENTAGE_DEFAULT = 20.0;
    protected static final String MIN_FREE_VOLUME_SPACE_PERCENTAGE_DOC = "The log.dir volume will have at least the specified percentage of free space during and after the rebalance. For example, if the total volume space is 100 GB and this config is defined as 20, the rebalancer will use up to 80 GB during the rebalance .This is only supported in Confluent 3.2 (for both rebalancer and brokers) and if every broker in the cluster has a single log.dir. This is enabled by default if supported and disabled otherwise.";
    public static final String MAX_CONCURRENT_LEADER_MOVES = "confluent.rebalancer.max.concurrent.moves.per.leader";
    public static final int MAX_CONCURRENT_LEADER_MOVES_DEFAULT = 4;
    protected static final String MAX_CONCURRENT_LEADER_MOVES_DOC = "The maximum number of partitions to reassign concurrently for each preferred leader. This is only relevant when the `--incremental` flag is passed. Note that reassignments per active leader may exceed this value when the active leader is not the preferred leader.";
    private static final ConfigDef config = new ConfigDef().define("confluent.rebalancer.metrics.bootstrap.servers", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, "The kafka brokers where the metrics reporter publishes cluster level metrics to. These metrics are needed to make decisions about where to place cluster data.").define("confluent.rebalancer.metrics.topic", ConfigDef.Type.STRING, (Object)"_confluent-metrics", ConfigDef.Importance.LOW, "The topic where the metrics reporter publishes its metrics to").define("confluent.rebalancer.metrics.collection.timeout.ms", ConfigDef.Type.INT, (Object)60000, ConfigDef.Importance.LOW, "The maximum amount of time the rebalancer will collect metrics for. If the collection does not succeed before the timeout elapses, the rebalance command will fail.").define("confluent.license", ConfigDef.Type.PASSWORD, (Object)"", ConfigDef.Importance.HIGH, "Confluent will issue a license key to each subscriber. The license key will be a short snippet of text that you can copy and paste. Without the license key, you can use the Confluent Rebalancer for a 30-day trial period. If you are a subscriber and don't have a license key, please contact Confluent Support at support@confluent.io.").define("confluent.license.topic", ConfigDef.Type.STRING, (Object)"_confluent-license", ConfigDef.Importance.HIGH, "Name of the Kafka topic used for Confluent Platform configuration, including licensing information.").define("confluent.license.topic.replication.factor", ConfigDef.Type.INT, (Object)3, ConfigDef.Importance.LOW, "The replication factor for the Kafka topic used for Confluent Platform configuration, including licensing information. This is used only if the topic does not already exist, and the default of 3 is appropriate for production use. If you are using a development environment with less than 3 brokers, you must set this to the number of brokers (often 1).").define("confluent.license.bootstrap.servers", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, "A list of host/port pairs to use for establishing the initial connection to the Kafka cluster used for licensing. All servers in the cluster will be discovered from the initial connection. This list should be in the form <code>host1:port1,host2:port2,...</code>. Since these servers are just used for the initial connection to discover the full cluster membership (which may change dynamically), this list need not contain the full set of servers (you may want more than one, though, in case a server is down).").define("confluent.rebalancer.min.free.volume.space.percentage", ConfigDef.Type.DOUBLE, (Object)20.0, (ConfigDef.Validator)ConfigDef.Range.between((Number)0, (Number)100), ConfigDef.Importance.LOW, "The log.dir volume will have at least the specified percentage of free space during and after the rebalance. For example, if the total volume space is 100 GB and this config is defined as 20, the rebalancer will use up to 80 GB during the rebalance .This is only supported in Confluent 3.2 (for both rebalancer and brokers) and if every broker in the cluster has a single log.dir. This is enabled by default if supported and disabled otherwise.").define("confluent.rebalancer.max.concurrent.moves.per.leader", ConfigDef.Type.INT, (Object)4, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, "The maximum number of partitions to reassign concurrently for each preferred leader. This is only relevant when the `--incremental` flag is passed. Note that reassignments per active leader may exceed this value when the active leader is not the preferred leader.");

    public static void main(String[] args) {
        System.out.println(config.toRst());
    }

    public RebalancerConfig(Properties props) {
        super(config, (Map)ConfigUtils.translateDeprecated((Properties)props, (String[][])new String[][]{{CONFLUENT_LICENSE_CONFIG, "confluent.rebalancer.license"}}));
    }

    public Properties consumerProps() {
        Properties consumerProps = new Properties();
        consumerProps.putAll((Map<?, ?>)this.originalsWithPrefix(METRICS_PREFIX));
        return consumerProps;
    }

    public Password license() {
        return this.getPassword(CONFLUENT_LICENSE_CONFIG);
    }

    public String licenseTopic() {
        return this.getString(CONFLUENT_LICENSE_TOPIC_CONFIG);
    }

    public Map<String, Object> licenseProducerConfig() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.putAll(this.originalsWithPrefix(CONFLUENT_LICENSE_PREFIX));
        result.putAll(this.originalsWithPrefix(CONFLUENT_LICENSE_PRODUCER_PREFIX));
        return result;
    }

    public Map<String, Object> licenseConsumerConfig() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.putAll(this.originalsWithPrefix(CONFLUENT_LICENSE_PREFIX));
        result.putAll(this.originalsWithPrefix(CONFLUENT_LICENSE_CONSUMER_PREFIX));
        return result;
    }

    public Map<String, Object> licenseAdminConfig() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.putAll(this.originalsWithPrefix(CONFLUENT_LICENSE_PREFIX));
        result.putAll(this.originalsWithPrefix(CONFLUENT_LICENSE_TOPIC_PREFIX));
        result.putAll(this.originalsWithPrefix(CONFLUENT_LICENSE_PRODUCER_PREFIX));
        result.putAll(this.originalsWithPrefix(CONFLUENT_LICENSE_CONSUMER_PREFIX));
        return result;
    }
}

