/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.databalancing;

import io.confluent.kafka.databalancing.topology.PartitionAssignment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kafka.admin.ReassignPartitionsCommand;
import kafka.controller.ReplicaAssignment;
import org.apache.kafka.common.TopicPartition;
import scala.collection.JavaConverters;
import scala.collection.Map;
import scala.collection.Seq;

public class ScalaUtils {
    public static List<Integer> fromScalaSeqInt(Seq<Object> seq) {
        ArrayList<Integer> result = new ArrayList<Integer>(seq.length());
        for (Object v : JavaConverters.asJavaIterable(seq)) {
            if (v instanceof Integer) {
                result.add((Integer)v);
                continue;
            }
            throw new ClassCastException("Expected an Integer, but found " + v + " with type " + v.getClass());
        }
        return result;
    }

    public static java.util.Map<TopicPartition, PartitionAssignment> assignmentFromScalaMap(Map<TopicPartition, ReplicaAssignment> assignments) {
        HashMap<TopicPartition, PartitionAssignment> result = new HashMap<TopicPartition, PartitionAssignment>(assignments.size());
        for (Map.Entry entry : JavaConverters.mapAsJavaMap(assignments).entrySet()) {
            TopicPartition tp = (TopicPartition)entry.getKey();
            ReplicaAssignment assignment = (ReplicaAssignment)entry.getValue();
            List<Integer> replicas = ScalaUtils.fromScalaSeqInt((Seq<Object>)assignment.replicas());
            List<Integer> observers = ScalaUtils.fromScalaSeqInt((Seq<Object>)assignment.observers());
            result.put(tp, PartitionAssignment.create(replicas, observers));
        }
        return result;
    }

    public static Map<TopicPartition, ReassignPartitionsCommand.Assignment> assignmentToScalaMap(java.util.Map<TopicPartition, PartitionAssignment> assignment) {
        HashMap<TopicPartition, ReassignPartitionsCommand.Assignment> result = new HashMap<TopicPartition, ReassignPartitionsCommand.Assignment>(assignment.size());
        for (Map.Entry<TopicPartition, PartitionAssignment> entry : assignment.entrySet()) {
            TopicPartition tp = entry.getKey();
            ArrayList<Integer> replicaIds = new ArrayList<Integer>(entry.getValue().replicaIds());
            ArrayList<Integer> observerIds = new ArrayList<Integer>(entry.getValue().observerIds());
            ReassignPartitionsCommand.Assignment scalaAssignment = new ReassignPartitionsCommand.Assignment((Seq)JavaConverters.asScalaBuffer(replicaIds), (Seq)JavaConverters.asScalaBuffer(observerIds));
            result.put(tp, scalaAssignment);
        }
        return JavaConverters.mapAsScalaMap(result);
    }
}

