/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.databalancing.license;

import io.confluent.kafka.databalancing.RebalancerConfig;
import io.confluent.kafka.databalancing.license.LicenseValidator;
import io.confluent.license.InvalidLicenseException;
import io.confluent.license.LicenseManager;

public class DefaultLicenseValidator
implements LicenseValidator {
    @Override
    public void validateLicense(RebalancerConfig rebalancerConfig) throws LicenseValidator.ValidationFailedException {
        LicenseManager licenseManager = new LicenseManager(rebalancerConfig.licenseTopic(), rebalancerConfig.licenseProducerConfig(), rebalancerConfig.licenseConsumerConfig(), rebalancerConfig.licenseAdminConfig());
        try {
            licenseManager.registerOrValidateLicense(rebalancerConfig.license().value());
        }
        catch (InvalidLicenseException e) {
            throw new LicenseValidator.ValidationFailedException("Could not validate your license: " + e.getMessage());
        }
        finally {
            licenseManager.stop();
        }
    }
}

