/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.databalancing.report;

import io.confluent.kafka.databalancing.RebalancePolicy;
import io.confluent.kafka.databalancing.Utils;
import io.confluent.kafka.databalancing.metric.Metrics;
import io.confluent.kafka.databalancing.topology.Broker;
import io.confluent.kafka.databalancing.topology.BrokerMetadata;
import io.confluent.kafka.databalancing.topology.ClusterAssignment;
import io.confluent.kafka.databalancing.topology.PartitionAssignment;
import io.confluent.kafka.databalancing.topology.Replica;
import io.confluent.metrics.record.ConfluentMetric;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.metadata.TopicPlacement;

public class RebalanceReport {
    private static final Comparator<Broker> BROKER_COMPARATOR = Comparator.comparingInt(Broker::id);
    private static final DecimalFormat PERCENTAGE_FORMAT = new DecimalFormat("###.#");
    private static final int FREE_VOLUME_PERCENTAGE_DISPLAY_THRESHOLD = 40;
    private final List<Replica> replicasAdded;
    private final Set<Integer> targetBrokers;
    private final long movingReplicasSize;
    private final Metrics metrics;
    private final Collection<Broker> brokersToRemove;
    private final List<String> allRacks;
    private final Map<Broker, Collection<TopicPartition>> currentBrokerToLeaders;
    private final Map<Broker, Collection<TopicPartition>> proposedBrokerToLeaders;
    private final RebalancePolicy.Config policyConfig;
    private int leaderChanges;
    private int partitionChanges;
    private final Map<Broker, Collection<TopicPartition>> currentBrokerToReplicas;
    private final Map<Broker, Collection<TopicPartition>> proposedBrokerToReplicas;
    private final Set<Broker> proposedBrokersWithNoReplicas;
    private final List<Broker> allBrokers;
    private final Map<Broker, Long> brokerToPositiveSizeDiffDuringRebalance;
    private final Map<Broker, Long> brokerToSizeDiffAfterRebalance;
    private final Map<String, Long> currentRackToReplicaCount;
    private final Map<String, Long> currentRackToLeaderCount;
    private final Map<String, Long> currentRackToSize;
    private final Map<String, Long> proposedRackToReplicaCount;
    private final Map<String, Long> proposedRackToLeaderCount;
    private final Map<String, Long> proposedRackToSize;

    public RebalanceReport(Collection<BrokerMetadata> brokers, Map<String, TopicPlacement> topicPlacement, ClusterAssignment currentAssignment, ClusterAssignment proposedAssignment, Metrics metrics, Collection<Broker> brokersToRemove, RebalancePolicy.Config policyConfig) {
        this(Utils.brokersMap(brokers), topicPlacement, currentAssignment, proposedAssignment, metrics, brokersToRemove, policyConfig);
    }

    public RebalanceReport(Map<Broker, BrokerMetadata> brokers, Map<String, TopicPlacement> topicPlacement, ClusterAssignment currentAssignment, ClusterAssignment proposedAssignment, Metrics metrics, Collection<Broker> brokersToRemove, RebalancePolicy.Config policyConfig) {
        this.metrics = metrics;
        this.brokersToRemove = brokersToRemove;
        this.currentBrokerToReplicas = currentAssignment.brokerToReplicas();
        this.currentBrokerToLeaders = currentAssignment.brokerToLeaders();
        this.proposedBrokerToReplicas = proposedAssignment.brokerToReplicas();
        this.proposedBrokerToLeaders = proposedAssignment.brokerToLeaders();
        this.policyConfig = policyConfig;
        this.allRacks = RebalanceReport.sortedRacks(brokers);
        this.allBrokers = RebalanceReport.sortedBrokers(brokers.keySet());
        this.replicasAdded = new ArrayList<Replica>();
        this.targetBrokers = new HashSet<Integer>();
        for (TopicPartition tp : currentAssignment.asMap().keySet()) {
            Optional<Broker> proposedLeader;
            PartitionAssignment proposed;
            PartitionAssignment current = currentAssignment.assignment(tp);
            if (!current.equals(proposed = proposedAssignment.assignment(tp))) {
                ++this.partitionChanges;
            }
            ArrayList<Integer> brokersAdded = new ArrayList<Integer>(proposed.replicaIds());
            brokersAdded.removeAll(current.replicaIds());
            for (Integer brokerAdded : brokersAdded) {
                this.replicasAdded.add(new Replica(tp, Optional.ofNullable(topicPlacement.get(tp.topic())), new Broker(brokerAdded)));
            }
            this.targetBrokers.addAll(brokersAdded);
            Optional<Broker> currentLeader = current.preferredLeader();
            if (currentLeader.equals(proposedLeader = proposed.preferredLeader())) continue;
            ++this.leaderChanges;
        }
        this.movingReplicasSize = Math.round((double)this.replicasSize(this.replicasAdded) / 1000.0 * 1000.0);
        this.brokerToPositiveSizeDiffDuringRebalance = new HashMap<Broker, Long>();
        this.brokerToSizeDiffAfterRebalance = new HashMap<Broker, Long>();
        this.populateBrokerToDiffMaps();
        this.proposedBrokersWithNoReplicas = new HashSet<Broker>(currentAssignment.brokers());
        this.proposedBrokersWithNoReplicas.removeAll(this.proposedBrokerToReplicas.keySet());
        this.currentRackToLeaderCount = new HashMap<String, Long>();
        this.currentRackToReplicaCount = new HashMap<String, Long>();
        this.currentRackToSize = new HashMap<String, Long>();
        this.proposedRackToLeaderCount = new HashMap<String, Long>();
        this.proposedRackToReplicaCount = new HashMap<String, Long>();
        this.proposedRackToSize = new HashMap<String, Long>();
        this.populateRackMaps(brokers);
    }

    private void populateRackMaps(Map<Broker, BrokerMetadata> brokers) {
        for (BrokerMetadata brokerMeta : brokers.values()) {
            if (!brokerMeta.rack().isPresent()) continue;
            String rack = brokerMeta.rack().get();
            Broker broker = new Broker(brokerMeta.id());
            long currentLeaderCount = this.getOrEmpty(this.currentBrokerToLeaders, broker).size();
            this.currentRackToLeaderCount.put(rack, this.getOrZero(this.currentRackToLeaderCount, rack) + currentLeaderCount);
            Collection<TopicPartition> currentReplicas = this.getOrEmpty(this.currentBrokerToReplicas, broker);
            this.currentRackToReplicaCount.put(rack, this.getOrZero(this.currentRackToReplicaCount, rack) + (long)currentReplicas.size());
            this.currentRackToSize.put(rack, this.getOrZero(this.currentRackToSize, rack) + this.partitionsSize(currentReplicas));
            long proposedLeaderCount = this.getOrEmpty(this.proposedBrokerToLeaders, broker).size();
            this.proposedRackToLeaderCount.put(rack, this.getOrZero(this.proposedRackToLeaderCount, rack) + proposedLeaderCount);
            Collection<TopicPartition> proposedReplicas = this.getOrEmpty(this.proposedBrokerToReplicas, broker);
            this.proposedRackToReplicaCount.put(rack, this.getOrZero(this.proposedRackToReplicaCount, rack) + (long)proposedReplicas.size());
            this.proposedRackToSize.put(rack, this.getOrZero(this.proposedRackToSize, rack) + this.partitionsSize(proposedReplicas));
        }
    }

    private void populateBrokerToDiffMaps() {
        for (Broker broker : this.proposedBrokerToReplicas.keySet()) {
            Collection<TopicPartition> currentPartitions = this.getOrEmpty(this.currentBrokerToReplicas, broker);
            Collection<TopicPartition> proposedPartitions = this.getOrEmpty(this.proposedBrokerToReplicas, broker);
            HashSet<TopicPartition> partitionsAdded = new HashSet<TopicPartition>(proposedPartitions);
            partitionsAdded.removeAll(currentPartitions);
            long partitionsAddedSize = this.partitionsSize(partitionsAdded);
            if (partitionsAddedSize <= 0L) continue;
            this.brokerToPositiveSizeDiffDuringRebalance.put(broker, partitionsAddedSize);
            HashSet<TopicPartition> partitionsRemoved = new HashSet<TopicPartition>(currentPartitions);
            partitionsRemoved.removeAll(proposedPartitions);
            this.brokerToSizeDiffAfterRebalance.put(broker, partitionsAddedSize - this.partitionsSize(partitionsRemoved));
        }
    }

    private static List<String> sortedRacks(Map<Broker, BrokerMetadata> registeredBrokers) {
        HashSet<String> racks = new HashSet<String>();
        for (BrokerMetadata b : registeredBrokers.values()) {
            if (!b.rack().isPresent()) continue;
            racks.add(b.rack().get());
        }
        return Utils.sorted(racks);
    }

    private static List<Broker> sortedBrokers(Collection<Broker> brokers) {
        return Utils.sorted(brokers, BROKER_COMPARATOR);
    }

    public void print(PrintStream out, boolean verbose) {
        out.println("You are about to move " + this.replicasAdded.size() + " replica(s) for " + this.partitions(this.replicasAdded).size() + " partitions to " + this.targetBrokers.size() + " broker(s) with total size " + this.toMb(this.movingReplicasSize) + " MB.");
        out.println("The preferred leader for " + this.leaderChanges + " partition(s) will be changed.");
        out.println("In total, the assignment for " + this.partitionChanges + " partitions will be changed.");
        Double minFreeVolumeSpacePercentage = this.policyConfig.minFreeVolumeSpacePercentage();
        if (minFreeVolumeSpacePercentage != null) {
            out.printf("The minimum free volume space is set to %.1f%%.%n", minFreeVolumeSpacePercentage);
        }
        if (!this.brokersToRemove.isEmpty()) {
            out.println("\nYou have requested all replicas to be moved out of " + this.brokersToRemove.size() + " broker(s) with id(s): " + this.brokersString(this.brokersToRemove) + ".");
            if (this.proposedBrokersWithNoReplicas.containsAll(this.brokersToRemove)) {
                out.println("After the rebalance, these broker(s) will have no replicas.");
            } else {
                HashSet<Broker> brokers = new HashSet<Broker>(this.brokersToRemove);
                brokers.removeAll(this.proposedBrokersWithNoReplicas);
                out.println("However, the following brokers will still have at least one replica after the rebalance: " + this.brokersString(brokers));
            }
        }
        if (minFreeVolumeSpacePercentage == null) {
            this.printBrokersRequiringMoreSpace(out);
        } else {
            this.printBrokersWithLeastSpace(out);
        }
        this.printMinMaxBrokers(out);
        if (this.allRacks.isEmpty()) {
            out.println("No racks are defined.");
        } else {
            out.println("\nRack stats (before -> after):");
            this.printDetailedRackStats(out);
        }
        if (verbose) {
            out.println("\nBroker stats (before -> after):");
            this.printDetailedBrokerStats(out);
        }
        out.println();
    }

    private Collection<TopicPartition> partitions(List<Replica> replicas) {
        HashSet<TopicPartition> partitions = new HashSet<TopicPartition>();
        for (Replica replica : replicas) {
            partitions.add(replica.topicPartition());
        }
        return partitions;
    }

    private void printDetailedRackStats(PrintStream out) {
        String format = "\t%-10s %-15s %-15s %-20s";
        out.println(String.format(format, "Rack", "Leader Count", "Replica Count", "Size (MB)"));
        for (String rack : this.allRacks) {
            String line = String.format(format, rack, this.getOrZero(this.currentRackToLeaderCount, rack) + " -> " + this.getOrZero(this.proposedRackToLeaderCount, rack), this.getOrZero(this.currentRackToReplicaCount, rack) + " -> " + this.getOrZero(this.proposedRackToReplicaCount, rack), this.toMb(this.getOrZero(this.currentRackToSize, rack)) + " -> " + this.toMb(this.getOrZero(this.proposedRackToSize, rack)));
            out.println(line);
        }
    }

    private <K, E> K maxCount(Collection<K> keys, Map<K, Collection<E>> map) {
        return this.min(keys, map, new Comparator<Collection<E>>(){

            @Override
            public int compare(Collection<E> o1, Collection<E> o2) {
                return Integer.compare(o2.size(), o1.size());
            }
        }, Collections.emptyList());
    }

    private <K> K maxSize(Collection<K> keys, Map<K, Collection<TopicPartition>> map) {
        return this.min(keys, map, new Comparator<Collection<TopicPartition>>(){

            @Override
            public int compare(Collection<TopicPartition> o1, Collection<TopicPartition> o2) {
                return Long.compare(RebalanceReport.this.partitionsSize(o2), RebalanceReport.this.partitionsSize(o1));
            }
        }, Collections.emptyList());
    }

    private <K, V> K min(Collection<K> keys, Map<K, V> map, Comparator<V> comparator, V defaultValue) {
        K result = null;
        Object minValue = null;
        for (K key : keys) {
            V value = map.get(key);
            if (value == null) {
                value = defaultValue;
            }
            if (result != null && comparator.compare(value, minValue) >= 0) continue;
            result = key;
            minValue = value;
        }
        return result;
    }

    private <K, E> K minCount(Collection<K> keys, Map<K, Collection<E>> map) {
        return this.min(keys, map, new Comparator<Collection<E>>(){

            @Override
            public int compare(Collection<E> o1, Collection<E> o2) {
                return Integer.compare(o1.size(), o2.size());
            }
        }, Collections.emptyList());
    }

    private <K> K minSize(Collection<K> keys, Map<K, Collection<TopicPartition>> map) {
        return this.min(keys, map, new Comparator<Collection<TopicPartition>>(){

            @Override
            public int compare(Collection<TopicPartition> o1, Collection<TopicPartition> o2) {
                return Long.compare(RebalanceReport.this.partitionsSize(o1), RebalanceReport.this.partitionsSize(o2));
            }
        }, Collections.emptyList());
    }

    private void printMinMaxBrokers(PrintStream out) {
        Broker currentBrokerWithMinSize = this.minSize(this.allBrokers, this.currentBrokerToReplicas);
        long currentMinSize = this.partitionsSize(this.getOrEmpty(this.currentBrokerToReplicas, currentBrokerWithMinSize));
        Broker currentBrokerWithMaxSize = this.maxSize(this.allBrokers, this.currentBrokerToReplicas);
        long currentMaxSize = this.partitionsSize(this.getOrEmpty(this.currentBrokerToReplicas, currentBrokerWithMaxSize));
        Broker proposedBrokerWithMinSize = this.minSize(this.allBrokers, this.proposedBrokerToReplicas);
        long proposedMinSize = this.partitionsSize(this.getOrEmpty(this.proposedBrokerToReplicas, proposedBrokerWithMinSize));
        Broker proposedBrokerWithMaxSize = this.maxSize(this.allBrokers, this.proposedBrokerToReplicas);
        long proposedMaxSize = this.partitionsSize(this.getOrEmpty(this.proposedBrokerToReplicas, proposedBrokerWithMaxSize));
        Broker currentBrokerWithMinLeaders = this.minCount(this.allBrokers, this.currentBrokerToLeaders);
        int currentMinLeaderCount = this.getOrEmpty(this.currentBrokerToLeaders, currentBrokerWithMinLeaders).size();
        Broker currentBrokerWithMaxLeaders = this.maxCount(this.allBrokers, this.currentBrokerToLeaders);
        int currentMaxLeaderCount = this.getOrEmpty(this.currentBrokerToLeaders, currentBrokerWithMaxLeaders).size();
        Broker proposedBrokerWithMinLeaders = this.minCount(this.allBrokers, this.proposedBrokerToLeaders);
        int proposedMinLeaderCount = this.getOrEmpty(this.proposedBrokerToLeaders, proposedBrokerWithMinLeaders).size();
        Broker proposedBrokerWithMaxLeaders = this.maxCount(this.allBrokers, this.proposedBrokerToLeaders);
        int proposedMaxLeaderCount = this.getOrEmpty(this.proposedBrokerToLeaders, proposedBrokerWithMaxLeaders).size();
        Broker currentBrokerWithMinReplicas = this.minCount(this.allBrokers, this.currentBrokerToReplicas);
        int currentMinReplicaCount = this.getOrEmpty(this.currentBrokerToReplicas, currentBrokerWithMinReplicas).size();
        Broker currentBrokerWithMaxReplicas = this.maxCount(this.allBrokers, this.currentBrokerToReplicas);
        int currentMaxReplicaCount = this.getOrEmpty(this.currentBrokerToReplicas, currentBrokerWithMaxReplicas).size();
        Broker proposedBrokerWithMinReplicas = this.minCount(this.allBrokers, this.proposedBrokerToReplicas);
        int proposedMinReplicaCount = this.getOrEmpty(this.proposedBrokerToReplicas, proposedBrokerWithMinReplicas).size();
        Broker proposedBrokerWithMaxReplicas = this.maxCount(this.allBrokers, this.proposedBrokerToReplicas);
        int proposedMaxReplicaCount = this.getOrEmpty(this.proposedBrokerToReplicas, proposedBrokerWithMaxReplicas).size();
        out.println("\nMin/max stats for brokers (before -> after):");
        String format = "\t%-5s %-28s %-28s %-35s";
        out.println(String.format(format, "Type", "Leader Count", "Replica Count", "Size (MB)"));
        String minLeaderCount = this.minOrMaxLine(currentMinLeaderCount, currentBrokerWithMinLeaders, proposedMinLeaderCount, proposedBrokerWithMinLeaders);
        String minReplicaCount = this.minOrMaxLine(currentMinReplicaCount, currentBrokerWithMinReplicas, proposedMinReplicaCount, proposedBrokerWithMinReplicas);
        String minSize = this.minOrMaxLine(this.toMb(currentMinSize), currentBrokerWithMinSize, this.toMb(proposedMinSize), proposedBrokerWithMinSize);
        String maxLeaderCount = this.minOrMaxLine(currentMaxLeaderCount, currentBrokerWithMaxLeaders, proposedMaxLeaderCount, proposedBrokerWithMaxLeaders);
        String maxReplicaCount = this.minOrMaxLine(currentMaxReplicaCount, currentBrokerWithMaxReplicas, proposedMaxReplicaCount, proposedBrokerWithMaxReplicas);
        String maxSize = this.minOrMaxLine(this.toMb(currentMaxSize), currentBrokerWithMaxSize, this.toMb(proposedMaxSize), proposedBrokerWithMaxSize);
        out.println(String.format(format, "Min", minLeaderCount, minReplicaCount, minSize));
        out.println(String.format(format, "Max", maxLeaderCount, maxReplicaCount, maxSize));
    }

    private String minOrMaxLine(long currentValue, Broker currentBroker, long proposedValue, Broker proposedBroker) {
        return this.minOrMaxLine(Long.toString(currentValue), currentBroker, Long.toString(proposedValue), proposedBroker);
    }

    private String minOrMaxLine(String currentValue, Broker currentBroker, String proposedValue, Broker proposedBroker) {
        return currentValue + " (id: " + currentBroker.id() + ") -> " + proposedValue + " (id: " + proposedBroker.id() + ")";
    }

    private void printBrokersRequiringMoreSpace(PrintStream out) {
        if (this.brokerToPositiveSizeDiffDuringRebalance.isEmpty()) {
            return;
        }
        out.println("\nThe following brokers will require more volume space during the rebalance and, in some cases, after the rebalance:");
        String format = "\t%-10s %-15s %-22s %-15s";
        out.println(String.format(format, "Broker", "Current (MB)", "During Rebalance (MB)", "After Rebalance (MB)"));
        for (Broker broker : RebalanceReport.sortedBrokers(this.brokerToPositiveSizeDiffDuringRebalance.keySet())) {
            long currentSize = this.partitionsSize(this.getOrEmpty(this.currentBrokerToReplicas, broker));
            long duringSize = currentSize + this.getOrZero(this.brokerToPositiveSizeDiffDuringRebalance, broker);
            long afterSize = currentSize + this.getOrZero(this.brokerToSizeDiffAfterRebalance, broker);
            String line = String.format(format, broker.id(), this.toMb(currentSize), this.toMb(duringSize), this.toMb(afterSize));
            out.println(line);
        }
    }

    private void printBrokersWithLeastSpace(PrintStream out) {
        ArrayList<Broker> brokers = new ArrayList<Broker>(this.allBrokers);
        brokers.removeAll(this.brokersToRemove);
        brokers.removeIf(broker -> this.volumeFreeBytes((Broker)broker) == null);
        List<Broker> sortedBrokers = Utils.sorted(brokers, new Comparator<Broker>(){

            @Override
            public int compare(Broker b1, Broker b2) {
                int result = Long.compare(RebalanceReport.this.volumeFreeBytes(b1), RebalanceReport.this.volumeFreeBytes(b2));
                if (result == 0) {
                    result = BROKER_COMPARATOR.compare(b1, b2);
                }
                return result;
            }
        });
        long displayThreshold = Math.round(Math.max(this.policyConfig.minFreeVolumeSpacePercentage(), 40.0));
        String format = "\t%-10s %-18s %-28s %-28s %-28s %-28s";
        ArrayList<String> lines = new ArrayList<String>();
        for (Broker broker2 : sortedBrokers) {
            long currentSize = this.partitionsSize(this.getOrEmpty(this.currentBrokerToReplicas, broker2));
            long totalSpace = this.volumeTotalBytes(broker2);
            long diffDuringRebalance = this.getOrZero(this.brokerToPositiveSizeDiffDuringRebalance, broker2);
            long duringSize = currentSize + diffDuringRebalance;
            long duringFreeSpace = this.volumeFreeBytes(broker2) - diffDuringRebalance;
            if (!((double)duringFreeSpace / (double)totalSpace < (double)displayThreshold / 100.0)) continue;
            long diffAfterRebalance = this.getOrZero(this.brokerToSizeDiffAfterRebalance, broker2);
            long afterSize = currentSize + diffAfterRebalance;
            long afterFreeSpace = this.volumeFreeBytes(broker2) - diffAfterRebalance;
            String line = String.format(format, broker2.id(), this.toMb(currentSize), this.toMb(duringSize), this.toPercent(duringFreeSpace, totalSpace), this.toMb(afterSize), this.toPercent(afterFreeSpace, totalSpace));
            lines.add(line);
        }
        if (!lines.isEmpty()) {
            out.println("\nThe following brokers will have less than " + displayThreshold + "% of free volume space during the rebalance:");
            out.println(String.format(format, "Broker", "Current Size (MB)", "Size During Rebalance (MB)", "Free % During Rebalance", "Size After Rebalance (MB)", "Free % After Rebalance"));
            for (String line : lines) {
                out.println(line);
            }
        }
    }

    private String toPercent(double numerator, double denominator) {
        return PERCENTAGE_FORMAT.format(numerator / denominator * 100.0);
    }

    private Long volumeFreeBytes(Broker broker) {
        ConfluentMetric.VolumeMetrics volumeMetrics = this.singleVolumeMetrics(broker);
        return volumeMetrics == null ? null : Long.valueOf(volumeMetrics.getUsableBytes());
    }

    private Long volumeTotalBytes(Broker broker) {
        ConfluentMetric.VolumeMetrics volumeMetrics = this.singleVolumeMetrics(broker);
        return volumeMetrics == null ? null : Long.valueOf(volumeMetrics.getTotalBytes());
    }

    private ConfluentMetric.VolumeMetrics singleVolumeMetrics(Broker broker) {
        List<ConfluentMetric.VolumeMetrics> volumeMetrics = this.metrics.brokerToVolumeMetrics().get(broker);
        if (volumeMetrics == null) {
            return null;
        }
        if (volumeMetrics.size() > 1) {
            throw new IllegalStateException("Found more than one volume for broker " + broker.id() + ", metrics: " + volumeMetrics);
        }
        return volumeMetrics.get(0);
    }

    private String toMb(long value) {
        return Utils.bytesToFormattedMb(value);
    }

    private void printDetailedBrokerStats(PrintStream out) {
        String format = "\t%-10s %-15s %-15s %-20s";
        ArrayList<String> headers = new ArrayList<String>(Arrays.asList("Broker", "Leader Count", "Replica Count", "Size (MB)"));
        if (this.policyConfig.hasMinFreeVolumeSpace()) {
            format = format + " %-20s";
            headers.add("Free Space (%)");
        }
        out.println(String.format(format, headers.toArray()));
        for (Broker broker : this.allBrokers) {
            Collection<TopicPartition> currentReplicas = this.getOrEmpty(this.currentBrokerToReplicas, broker);
            Collection<TopicPartition> proposedReplicas = this.getOrEmpty(this.proposedBrokerToReplicas, broker);
            long currentSize = this.partitionsSize(currentReplicas);
            long proposedSize = this.partitionsSize(proposedReplicas);
            ArrayList<Object> lineItems = new ArrayList<Object>(Arrays.asList(broker.id(), this.getOrEmpty(this.currentBrokerToLeaders, broker).size() + " -> " + this.getOrEmpty(this.proposedBrokerToLeaders, broker).size(), currentReplicas.size() + " -> " + proposedReplicas.size(), this.toMb(currentSize) + " -> " + this.toMb(proposedSize)));
            if (this.policyConfig.hasMinFreeVolumeSpace()) {
                Long totalBytes = this.volumeTotalBytes(broker);
                if (totalBytes == null) {
                    lineItems.add("N/A");
                } else {
                    Long currentFreeBytes = this.volumeFreeBytes(broker);
                    double proposedFreeBytes = currentFreeBytes + (currentSize - proposedSize);
                    lineItems.add(this.toPercent(currentFreeBytes.longValue(), totalBytes.longValue()) + " -> " + this.toPercent(proposedFreeBytes, totalBytes.longValue()));
                }
            }
            String line = String.format(format, lineItems.toArray());
            out.println(line);
        }
    }

    private <K> long getOrZero(Map<K, Long> map, K key) {
        Long result = map.get(key);
        return result == null ? 0L : result;
    }

    private <K, E> Collection<E> getOrEmpty(Map<K, Collection<E>> map, K key) {
        Collection<E> result = map.get(key);
        return result == null ? Collections.emptyList() : result;
    }

    private String brokersString(Collection<Broker> brokers) {
        ArrayList<Integer> brokerIds = new ArrayList<Integer>();
        for (Broker broker : brokers) {
            brokerIds.add(broker.id());
        }
        Collections.sort(brokerIds);
        return Utils.mkString(brokerIds, ",");
    }

    private long replicasSize(Collection<Replica> replicas) {
        long result = 0L;
        for (Replica replica : replicas) {
            result += this.metrics.partitionSize(replica.topicPartition());
        }
        return result;
    }

    private long partitionsSize(Collection<TopicPartition> partitions) {
        long result = 0L;
        for (TopicPartition partition : partitions) {
            result += this.metrics.partitionSize(partition);
        }
        return result;
    }

    public int partitionsChanges() {
        return this.partitionChanges;
    }
}

