/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.databalancing.topology;

import io.confluent.kafka.databalancing.CompareResult;
import io.confluent.kafka.databalancing.RebalanceContext;
import io.confluent.kafka.databalancing.Utils;
import io.confluent.kafka.databalancing.topology.Broker;
import io.confluent.kafka.databalancing.topology.Replica;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;

public final class TopologyUtils {
    public static final Comparator<TopicPartition> topicPartitionComparator = new Comparator<TopicPartition>(){

        @Override
        public int compare(TopicPartition tp1, TopicPartition tp2) {
            int result = tp1.topic().compareTo(tp2.topic());
            if (result == 0) {
                return Integer.compare(tp1.partition(), tp2.partition());
            }
            return result;
        }
    };

    private TopologyUtils() {
    }

    public static List<Broker> availableBrokers(RebalanceContext context, Collection<Broker> brokers) {
        return brokers.stream().filter(broker -> !context.isOffline((Broker)broker) && !context.brokersToBeRemoved().contains(broker)).collect(Collectors.toList());
    }

    public static List<Broker> availableBrokersOnRack(RebalanceContext context, String rack) {
        return TopologyUtils.availableBrokers(context, context.brokersOnRack(rack));
    }

    public static List<Broker> allAvailableBrokers(RebalanceContext context) {
        return TopologyUtils.availableBrokers(context, context.allBrokers());
    }

    public static List<Broker> leastLoadedBrokers(RebalanceContext context) {
        return TopologyUtils.sortBrokersBySize(context, TopologyUtils.allAvailableBrokers(context), null);
    }

    public static List<Broker> sortBrokersByReplicaCount(RebalanceContext context, Collection<Broker> brokers, String topic) {
        Map<Broker, Long> brokerTopicCounts = topic == null ? null : TopologyUtils.brokerReplicaCounts(context, brokers, topic);
        Map<Broker, Long> brokerCounts = TopologyUtils.brokerReplicaCounts(context, brokers, null);
        return Utils.sorted(brokers, TopologyUtils.brokerTopicComparator(brokerTopicCounts, brokerCounts));
    }

    public static List<Broker> sortBrokersByLeaderCount(RebalanceContext context, Collection<Broker> brokers, String topic) {
        Map<Broker, Long> brokerTopicCounts = topic == null ? null : TopologyUtils.brokerLeaderCounts(context, brokers, topic);
        Map<Broker, Long> brokerCounts = TopologyUtils.brokerLeaderCounts(context, brokers, null);
        return Utils.sorted(brokers, TopologyUtils.brokerTopicComparator(brokerTopicCounts, brokerCounts));
    }

    public static List<Broker> sortBrokersBySize(RebalanceContext context, Collection<Broker> brokers, String topic) {
        Map<Broker, Long> brokerTopicCounts = topic == null ? null : TopologyUtils.brokerSizes(context, brokers, topic);
        Map<Broker, Long> brokerCounts = TopologyUtils.brokerSizes(context, brokers, null);
        return Utils.sorted(brokers, TopologyUtils.brokerTopicComparator(brokerTopicCounts, brokerCounts));
    }

    public static List<Broker> sortBrokersByLeadersSize(RebalanceContext context, Collection<Broker> brokers, String topic) {
        Map<Broker, Long> brokerTopicCounts = topic == null ? null : TopologyUtils.brokerLeadersSizes(context, brokers, topic);
        Map<Broker, Long> brokerCounts = TopologyUtils.brokerLeadersSizes(context, brokers, null);
        return Utils.sorted(brokers, TopologyUtils.brokerTopicComparator(brokerTopicCounts, brokerCounts));
    }

    public static List<TopicPartition> sortPartitionsBySize(RebalanceContext context, Collection<TopicPartition> partitions) {
        HashMap<TopicPartition, Long> partitionToSize = new HashMap<TopicPartition, Long>();
        for (TopicPartition topicPartition : partitions) {
            if (partitionToSize.containsKey(topicPartition)) continue;
            partitionToSize.put(topicPartition, context.partitionSize(topicPartition));
        }
        return Utils.sorted(partitions, TopologyUtils.partitionSizeComparator(partitionToSize));
    }

    public static List<Broker> leastLoadedBrokersPreferringTheseRacks(RebalanceContext context, Set<String> racks) {
        List<Broker> leastLoaded = TopologyUtils.leastLoadedBrokers(context);
        TopologyUtils.uprank(leastLoaded, context.brokersOnRacks(racks));
        return leastLoaded;
    }

    static void uprank(List<Broker> all, Collection<Broker> toUprank) {
        ArrayList<Broker> upranked = new ArrayList<Broker>();
        Iterator<Broker> it = all.iterator();
        while (it.hasNext()) {
            Broker broker = it.next();
            if (!toUprank.contains(broker)) continue;
            it.remove();
            upranked.add(broker);
        }
        all.addAll(0, upranked);
    }

    public static List<Broker> leastLoadedBrokersPreferringOtherRacks(RebalanceContext context, Set<String> racks) {
        List<Broker> leastLoaded = TopologyUtils.leastLoadedBrokers(context);
        TopologyUtils.downrank(leastLoaded, context.brokersOnRacks(racks));
        return leastLoaded;
    }

    public static List<Broker> leastLoadedBrokersPreferRacksAvoidRacks(RebalanceContext context, Set<String> preferRacks, Set<String> avoidRacks) {
        List<Broker> leastLoaded = TopologyUtils.leastLoadedBrokers(context);
        TopologyUtils.downrank(leastLoaded, context.brokersOnRacks(avoidRacks));
        TopologyUtils.uprank(leastLoaded, context.brokersOnRacks(preferRacks));
        return leastLoaded;
    }

    public static void downrank(List<Broker> all, Collection<Broker> toDownrank) {
        ArrayList<Broker> downranked = new ArrayList<Broker>();
        Iterator<Broker> it = all.iterator();
        while (it.hasNext()) {
            Broker broker = it.next();
            if (!toDownrank.contains(broker)) continue;
            it.remove();
            downranked.add(broker);
        }
        all.addAll(downranked);
    }

    public static Set<String> racksFor(RebalanceContext context, TopicPartition topicPartition) {
        return context.racks(context.brokers(topicPartition));
    }

    public static Map<Broker, Long> brokerLeaderCounts(RebalanceContext context, Collection<Broker> brokers, String topic) {
        HashMap<Broker, Long> brokerToLeaderCount = new HashMap<Broker, Long>(brokers.size());
        for (Broker broker : brokers) {
            brokerToLeaderCount.put(broker, Long.valueOf(context.brokerTopicLeaderCount(broker, topic)));
        }
        return brokerToLeaderCount;
    }

    public static Map<Broker, Long> brokerReplicaCounts(RebalanceContext context, Collection<Broker> brokers, String topic) {
        HashMap<Broker, Long> brokerToReplicaCount = new HashMap<Broker, Long>(brokers.size());
        for (Broker broker : brokers) {
            brokerToReplicaCount.put(broker, Long.valueOf(context.brokerTopicReplicaCount(broker, topic)));
        }
        return brokerToReplicaCount;
    }

    public static Map<Broker, Long> brokerFirstObserverCounts(RebalanceContext context, Collection<Broker> brokers, String topic) {
        HashMap<Broker, Long> brokerToFirstObserverCount = new HashMap<Broker, Long>(brokers.size());
        for (Broker broker : brokers) {
            brokerToFirstObserverCount.put(broker, Long.valueOf(context.brokerTopicFirstObserverCount(broker, topic)));
        }
        return brokerToFirstObserverCount;
    }

    public static Map<String, Long> rackLeaderCounts(RebalanceContext context, String rack, String topic) {
        Collection<Broker> brokers = context.brokersOnRack(rack);
        HashMap<String, Long> rackToLeaderCount = new HashMap<String, Long>();
        for (Broker broker : brokers) {
            int brokerLeaderCount = context.brokerTopicLeaderCount(broker, topic);
            String brokerRack = rack == null ? context.brokerRack(broker) : rack;
            if (brokerRack == null) continue;
            Long rackLeaderCount = (Long)rackToLeaderCount.get(brokerRack);
            if (rackLeaderCount == null) {
                rackLeaderCount = 0L;
            }
            rackToLeaderCount.put(brokerRack, rackLeaderCount + (long)brokerLeaderCount);
        }
        return rackToLeaderCount;
    }

    public static Map<String, Long> rackReplicaCounts(RebalanceContext context, String rack, String topic) {
        Collection<Broker> brokers = context.brokersOnRack(rack);
        HashMap<String, Long> rackToReplicaCount = new HashMap<String, Long>();
        for (Broker broker : brokers) {
            int brokerReplicaCount = context.brokerTopicReplicaCount(broker, topic);
            String brokerRack = rack == null ? context.brokerRack(broker) : rack;
            if (brokerRack == null) continue;
            Long rackReplicaCount = (Long)rackToReplicaCount.get(brokerRack);
            if (rackReplicaCount == null) {
                rackReplicaCount = 0L;
            }
            rackToReplicaCount.put(brokerRack, rackReplicaCount + (long)brokerReplicaCount);
        }
        return rackToReplicaCount;
    }

    public static Map<String, Long> rackFirstObserverCounts(RebalanceContext context, String rack, String topic) {
        Collection<Broker> brokers = context.brokersOnRack(rack);
        HashMap<String, Long> rackToFirstObserverCount = new HashMap<String, Long>();
        for (Broker broker : brokers) {
            int brokerFirstObserverCount = context.brokerTopicFirstObserverCount(broker, topic);
            String brokerRack = rack == null ? context.brokerRack(broker) : rack;
            if (brokerRack == null) continue;
            Long rackReplicaCount = (Long)rackToFirstObserverCount.get(brokerRack);
            if (rackReplicaCount == null) {
                rackReplicaCount = 0L;
            }
            rackToFirstObserverCount.put(brokerRack, rackReplicaCount + (long)brokerFirstObserverCount);
        }
        return rackToFirstObserverCount;
    }

    public static Map<Broker, Long> brokerLeadersSizes(RebalanceContext context, Collection<Broker> brokers, String topic) {
        HashMap<Broker, Long> result = new HashMap<Broker, Long>(brokers.size());
        for (Broker broker : brokers) {
            result.put(broker, context.brokerTopicLeadersSize(broker, topic));
        }
        return result;
    }

    public static Map<Broker, Long> brokerSizes(RebalanceContext context, Collection<Broker> brokers, String topic) {
        HashMap<Broker, Long> result = new HashMap<Broker, Long>(brokers.size());
        for (Broker broker : brokers) {
            result.put(broker, context.brokerTopicSize(broker, topic));
        }
        return result;
    }

    public static Map<String, Long> rackLeadersSizes(RebalanceContext context, String rack, String topic) {
        Collection<Broker> brokers = context.brokersOnRack(rack);
        HashMap<String, Long> result = new HashMap<String, Long>();
        for (Broker broker : brokers) {
            long brokerSize = context.brokerTopicLeadersSize(broker, topic);
            String brokerRack = rack == null ? context.brokerRack(broker) : rack;
            if (brokerRack == null) continue;
            Long rackSize = (Long)result.get(brokerRack);
            if (rackSize == null) {
                rackSize = 0L;
            }
            result.put(brokerRack, rackSize + brokerSize);
        }
        return result;
    }

    public static Map<String, Long> rackSizes(RebalanceContext context, String rack, String topic) {
        Collection<Broker> brokers = context.brokersOnRack(rack);
        HashMap<String, Long> result = new HashMap<String, Long>();
        for (Broker broker : brokers) {
            long brokerSize = context.brokerTopicSize(broker, topic);
            String brokerRack = rack == null ? context.brokerRack(broker) : rack;
            if (brokerRack == null) continue;
            Long rackSize = (Long)result.get(brokerRack);
            if (rackSize == null) {
                rackSize = 0L;
            }
            result.put(brokerRack, rackSize + brokerSize);
        }
        return result;
    }

    public static List<Replica> replicas(RebalanceContext context, Collection<Broker> brokers, String topic) {
        ArrayList<Replica> replicas = new ArrayList<Replica>();
        for (Broker broker : brokers) {
            List<TopicPartition> topicPartitions = context.replicas(broker);
            for (TopicPartition tp : topicPartitions) {
                if (topic != null && !tp.topic().equals(topic)) continue;
                replicas.add(new Replica(tp, context.topicPlacement(tp.topic()), broker));
            }
        }
        return replicas;
    }

    public static List<TopicPartition> leaders(RebalanceContext context, List<Broker> brokers, String topic) {
        ArrayList<TopicPartition> leaders = new ArrayList<TopicPartition>();
        for (Broker broker : brokers) {
            List<TopicPartition> filteredLeaders;
            List<TopicPartition> brokerLeaders = context.leaders(broker);
            if (topic == null) {
                filteredLeaders = brokerLeaders;
            } else {
                filteredLeaders = new ArrayList<TopicPartition>();
                for (TopicPartition tp : brokerLeaders) {
                    if (!tp.topic().equals(topic)) continue;
                    filteredLeaders.add(tp);
                }
            }
            leaders.addAll(Utils.sorted(filteredLeaders, topicPartitionComparator));
        }
        return leaders;
    }

    public static List<Replica> availableReplicasOnRack(RebalanceContext context, String rack, String topic) {
        return TopologyUtils.replicas(context, TopologyUtils.availableBrokersOnRack(context, rack), topic);
    }

    public static List<TopicPartition> availableLeadersOnRack(RebalanceContext context, String rack, String topic) {
        return TopologyUtils.leaders(context, TopologyUtils.availableBrokersOnRack(context, rack), topic);
    }

    public static List<Replica> interleavedReplicas(RebalanceContext context, List<Broker> brokers, String topic) {
        ArrayList<Replica> result = new ArrayList<Replica>();
        LinkedHashMap<Broker, ArrayDeque<Object>> brokerToReplicas = new LinkedHashMap<Broker, ArrayDeque<Object>>(brokers.size());
        for (Broker broker : brokers) {
            ArrayDeque<Object> filteredReplicas;
            List<TopicPartition> replicas = Utils.sorted(context.replicas(broker), topicPartitionComparator);
            if (topic == null) {
                filteredReplicas = new ArrayDeque<TopicPartition>(replicas);
            } else {
                filteredReplicas = new ArrayDeque();
                for (TopicPartition tp : replicas) {
                    if (!tp.topic().equals(topic)) continue;
                    filteredReplicas.add(tp);
                }
            }
            if (filteredReplicas.isEmpty()) continue;
            brokerToReplicas.put(broker, filteredReplicas);
        }
        while (!brokerToReplicas.isEmpty()) {
            Iterator it = brokerToReplicas.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Broker broker = (Broker)entry.getKey();
                Deque replicas = (Deque)entry.getValue();
                TopicPartition partition = (TopicPartition)replicas.pollFirst();
                if (replicas.isEmpty()) {
                    it.remove();
                }
                result.add(new Replica(partition, context.topicPlacement(partition.topic()), broker));
            }
        }
        return result;
    }

    public static String formattedPartitionSize(RebalanceContext context, TopicPartition tp) {
        long partitionSize = context.partitionSize(tp);
        return Utils.bytesToFormattedMb(partitionSize);
    }

    public static String formattedBrokerSize(RebalanceContext context, Broker broker) {
        long brokerSize = context.brokerSize(broker);
        return Utils.bytesToFormattedMb(brokerSize);
    }

    public static CompareResult compareSizeFairness(long size1, long tp1Size, long size2, long tp2Size, double mean) {
        double current = TopologyUtils.square((double)size1 - mean) + TopologyUtils.square((double)size2 - mean);
        double candidate = TopologyUtils.square((double)(size1 - tp1Size + tp2Size) - mean) + TopologyUtils.square((double)(size2 + tp1Size - tp2Size) - mean);
        return CompareResult.fromInt(Double.compare(current, candidate));
    }

    private static double square(double value) {
        return value * value;
    }

    public static Comparator<Broker> brokerComparator(final Map<Broker, Long> brokerValueMap) {
        return new Comparator<Broker>(){

            @Override
            public int compare(Broker b1, Broker b2) {
                int result = Long.compare((Long)brokerValueMap.get(b1), (Long)brokerValueMap.get(b2));
                if (result == 0) {
                    return Long.compare(b1.id(), b2.id());
                }
                return result;
            }
        };
    }

    public static Comparator<Broker> brokerTopicComparator(final Map<Broker, Long> brokerTopicValueMap, final Map<Broker, Long> brokerValueMap) {
        return new Comparator<Broker>(){

            @Override
            public int compare(Broker b1, Broker b2) {
                int result;
                int n = result = brokerTopicValueMap == null ? 0 : Long.compare((Long)brokerTopicValueMap.get(b1), (Long)brokerTopicValueMap.get(b2));
                if (result != 0) {
                    return result;
                }
                result = Long.compare((Long)brokerValueMap.get(b1), (Long)brokerValueMap.get(b2));
                if (result != 0) {
                    return result;
                }
                return Long.compare(b1.id(), b2.id());
            }
        };
    }

    public static Comparator<String> rackTopicComparator(final Map<String, Long> rackTopicValueMap, final Map<String, Long> rackValueMap) {
        return new Comparator<String>(){

            @Override
            public int compare(String rack1, String rack2) {
                int result;
                int n = result = rackTopicValueMap == null ? 0 : Long.compare((Long)rackTopicValueMap.get(rack1), (Long)rackTopicValueMap.get(rack2));
                if (result != 0) {
                    return result;
                }
                result = Long.compare((Long)rackValueMap.get(rack1), (Long)rackValueMap.get(rack2));
                if (result != 0) {
                    return result;
                }
                return rack1.compareTo(rack2);
            }
        };
    }

    public static Comparator<String> rackComparator(final Map<String, Long> rackValueMap) {
        return new Comparator<String>(){

            @Override
            public int compare(String rack1, String rack2) {
                int result = Long.compare((Long)rackValueMap.get(rack1), (Long)rackValueMap.get(rack2));
                if (result != 0) {
                    return result;
                }
                return rack1.compareTo(rack2);
            }
        };
    }

    public static Comparator<TopicPartition> partitionSizeComparator(final Map<TopicPartition, Long> partitionValueMap) {
        return new Comparator<TopicPartition>(){

            @Override
            public int compare(TopicPartition tp1, TopicPartition tp2) {
                int result = Long.compare((Long)partitionValueMap.get(tp1), (Long)partitionValueMap.get(tp2));
                if (result != 0) {
                    return result;
                }
                return topicPartitionComparator.compare(tp1, tp2);
            }
        };
    }

    public static List<String> partitionsByTopicToLines(Set<TopicPartition> topicPartitions) {
        HashMap<String, ArrayList<Integer>> topicToPartitions = new HashMap<String, ArrayList<Integer>>();
        for (TopicPartition partition : topicPartitions) {
            ArrayList<Integer> partitionsForTopic = (ArrayList<Integer>)topicToPartitions.get(partition.topic());
            if (partitionsForTopic == null) {
                partitionsForTopic = new ArrayList<Integer>();
                topicToPartitions.put(partition.topic(), partitionsForTopic);
            }
            partitionsForTopic.add(partition.partition());
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String topic : Utils.sorted(topicToPartitions.keySet())) {
            List partitions = Utils.sorted((Collection)topicToPartitions.get(topic));
            String line = "Topic " + topic + ": " + Utils.mkString(partitions, ",");
            result.add(line);
        }
        return result;
    }
}

