/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.databalancing.view;

import io.confluent.kafka.databalancing.DefaultRebalancer;
import io.confluent.kafka.databalancing.IncrementalRebalancer;
import io.confluent.kafka.databalancing.Rebalancer;
import io.confluent.kafka.databalancing.RebalancerAdminClient;
import io.confluent.kafka.databalancing.RebalancerConfig;
import io.confluent.kafka.databalancing.RebalancerFactory;
import java.util.Objects;
import java.util.Properties;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;

public class DefaultRebalancerFactory
implements RebalancerFactory {
    @Override
    public Rebalancer create(Properties commandConfig, boolean incremental, RebalancerConfig rebalancerConfig) {
        Objects.requireNonNull(commandConfig, "Invalid command configs supplied!");
        RebalancerAdminClient admin = new RebalancerAdminClient((Admin)AdminClient.create((Properties)commandConfig));
        if (incremental) {
            return new IncrementalRebalancer(rebalancerConfig, admin);
        }
        return new DefaultRebalancer(rebalancerConfig, admin);
    }
}

