/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.databalancing.view;

import io.confluent.kafka.databalancing.CompareResult;
import io.confluent.kafka.databalancing.RebalanceContext;
import io.confluent.kafka.databalancing.constraint.Constraints;
import io.confluent.kafka.databalancing.constraint.RebalanceConstraints;
import io.confluent.kafka.databalancing.fairness.FirstObserverFairness;
import io.confluent.kafka.databalancing.fairness.LeaderFairness;
import io.confluent.kafka.databalancing.fairness.ReplicaFairness;
import io.confluent.kafka.databalancing.topology.Broker;
import io.confluent.kafka.databalancing.topology.Replica;
import io.confluent.kafka.databalancing.view.ClusterView;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.TopicPartition;

public abstract class RackFairView
implements ClusterView {
    protected final RebalanceContext context;
    protected final String topic;
    private final ReplicaFairness replicaFairness;
    private final LeaderFairness leaderFairness;
    private final FirstObserverFairness firstObserverFairness;
    private final Constraints constraints;
    private List<Replica> replicasOnAboveParBrokers;
    private List<TopicPartition> leadersOnAboveParBrokers;
    private List<Broker> brokersWithBelowParReplicaFairness;
    private List<Broker> brokersWithBelowParFirstObserverFairness;
    private List<Broker> brokersWithBelowParLeaderFairness;

    public RackFairView(RebalanceContext context, String topic) {
        this.context = context;
        this.topic = topic;
        this.replicaFairness = this.createReplicaFairness(context, topic);
        this.leaderFairness = this.createLeaderFairness(context, topic);
        this.firstObserverFairness = this.createFirstObserverFairness(context, topic);
        this.constraints = new Constraints(context, null);
    }

    protected abstract ReplicaFairness createReplicaFairness(RebalanceContext var1, String var2);

    protected abstract FirstObserverFairness createFirstObserverFairness(RebalanceContext var1, String var2);

    protected abstract LeaderFairness createLeaderFairness(RebalanceContext var1, String var2);

    protected abstract List<TopicPartition> createLeadersOnAboveParRacks(RebalanceContext var1, LeaderFairness var2, String var3);

    protected abstract List<Replica> createReplicasOnAboveParRacks(RebalanceContext var1, ReplicaFairness var2, String var3);

    protected abstract List<Broker> createBrokersWithBelowParLeaderMetric(RebalanceContext var1, LeaderFairness var2, String var3);

    protected abstract List<Broker> createBrokersWithBelowParReplicaMetric(RebalanceContext var1, ReplicaFairness var2, String var3);

    @Override
    public CompareResult compareLeaderFairness(TopicPartition topicPartition, Broker b1, Broker b2) {
        return this.leaderFairness.compareRackFairness(topicPartition, b1, b2);
    }

    @Override
    public CompareResult compareFirstObserverFairness(TopicPartition topicPartition, Broker b1, Broker b2) {
        return this.firstObserverFairness.compareRackFairness(topicPartition, b1, b2);
    }

    @Override
    public CompareResult compareReplicaFairness(TopicPartition topicPartition, Broker b1, Broker b2) {
        return this.replicaFairness.compareRackFairness(topicPartition, b1, b2);
    }

    @Override
    public CompareResult compareReplicaFairness(Broker b1, TopicPartition tp1, Broker b2, TopicPartition tp2) {
        return this.replicaFairness.compareRackFairness(b1, tp1, b2, tp2);
    }

    public ReplicaFairness replicaFairness() {
        return this.replicaFairness;
    }

    public LeaderFairness leaderFairness() {
        return this.leaderFairness;
    }

    @Override
    public List<Replica> replicasOnAboveParBrokers() {
        if (this.replicasOnAboveParBrokers == null) {
            this.replicasOnAboveParBrokers = Collections.unmodifiableList(this.createReplicasOnAboveParRacks(this.context, this.replicaFairness, this.topic));
        }
        return this.replicasOnAboveParBrokers;
    }

    @Override
    public List<Broker> brokersWithBelowParReplicaFairness() {
        if (this.brokersWithBelowParReplicaFairness == null) {
            this.brokersWithBelowParReplicaFairness = Collections.unmodifiableList(this.createBrokersWithBelowParReplicaMetric(this.context, this.replicaFairness, this.topic));
        }
        return this.brokersWithBelowParReplicaFairness;
    }

    @Override
    public List<TopicPartition> leadersOnAboveParBrokers() {
        if (this.leadersOnAboveParBrokers == null) {
            this.leadersOnAboveParBrokers = Collections.unmodifiableList(this.createLeadersOnAboveParRacks(this.context, this.leaderFairness, this.topic));
        }
        return this.leadersOnAboveParBrokers;
    }

    @Override
    public List<Broker> brokersWithBelowParLeaderFairness() {
        if (this.brokersWithBelowParLeaderFairness == null) {
            this.brokersWithBelowParLeaderFairness = Collections.unmodifiableList(this.createBrokersWithBelowParLeaderMetric(this.context, this.leaderFairness, this.topic));
        }
        return this.brokersWithBelowParLeaderFairness;
    }

    @Override
    public RebalanceConstraints constraints() {
        return this.constraints;
    }
}

