/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.databalancing.view;

import io.confluent.kafka.databalancing.RebalanceContext;
import io.confluent.kafka.databalancing.fairness.FirstObserverFairness;
import io.confluent.kafka.databalancing.fairness.FirstObserverSizeFairness;
import io.confluent.kafka.databalancing.fairness.LeaderFairness;
import io.confluent.kafka.databalancing.fairness.LeaderSizeFairness;
import io.confluent.kafka.databalancing.fairness.ReplicaFairness;
import io.confluent.kafka.databalancing.fairness.ReplicaSizeFairness;
import io.confluent.kafka.databalancing.topology.Broker;
import io.confluent.kafka.databalancing.topology.Replica;
import io.confluent.kafka.databalancing.topology.TopologyUtils;
import io.confluent.kafka.databalancing.view.ClusterView;
import io.confluent.kafka.databalancing.view.RackFairView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;

public class RackSizeFairView
extends RackFairView {
    private Map<String, Long> rackLeadersSizeMap;
    private Map<String, Long> rackSizeMap;

    public RackSizeFairView(RebalanceContext context, String topic) {
        super(context, topic);
    }

    @Override
    protected ReplicaFairness createReplicaFairness(RebalanceContext context, String topic) {
        return new ReplicaSizeFairness(context, null, topic);
    }

    @Override
    protected LeaderFairness createLeaderFairness(RebalanceContext context, String topic) {
        return new LeaderSizeFairness(context, null, topic);
    }

    @Override
    protected FirstObserverFairness createFirstObserverFairness(RebalanceContext context, String topic) {
        return new FirstObserverSizeFairness(context, null, topic);
    }

    @Override
    protected List<TopicPartition> createLeadersOnAboveParRacks(RebalanceContext context, LeaderFairness fairness, String topic) {
        ArrayList<TopicPartition> result = new ArrayList<TopicPartition>();
        for (String rack : fairness.aboveParRacks()) {
            List<TopicPartition> replicas = TopologyUtils.availableLeadersOnRack(context, rack, topic);
            this.sortRackLeaders(context, fairness, rack, replicas);
            result.addAll(replicas);
        }
        return result;
    }

    private void sortRackLeaders(final RebalanceContext context, LeaderFairness fairness, String rack, List<TopicPartition> replicas) {
        final double deviation = (double)this.rackLeadersSizeMap().get(rack).longValue() - fairness.rackFairValue();
        Collections.sort(replicas, new Comparator<TopicPartition>(){

            @Override
            public int compare(TopicPartition tp1, TopicPartition tp2) {
                long c1 = context.partitionSize(tp1);
                long c2 = context.partitionSize(tp2);
                int result = Double.compare(Math.abs((double)c1 - deviation), Math.abs((double)c2 - deviation));
                if (result != 0) {
                    return result;
                }
                if (c1 != c2) {
                    return Long.compare(c1, c2);
                }
                return TopologyUtils.topicPartitionComparator.compare(tp1, tp2);
            }
        });
    }

    private Map<String, Long> rackLeadersSizeMap() {
        if (this.rackLeadersSizeMap == null) {
            this.rackLeadersSizeMap = TopologyUtils.rackLeadersSizes(this.context, null, this.topic);
        }
        return this.rackLeadersSizeMap;
    }

    @Override
    protected List<Replica> createReplicasOnAboveParRacks(RebalanceContext context, ReplicaFairness fairness, String topic) {
        ArrayList<Replica> result = new ArrayList<Replica>();
        for (String rack : fairness.aboveParRacks()) {
            List<Replica> replicas = TopologyUtils.availableReplicasOnRack(context, rack, topic);
            this.sortRackReplicas(context, fairness, rack, replicas);
            result.addAll(replicas);
        }
        return result;
    }

    private void sortRackReplicas(final RebalanceContext context, ReplicaFairness fairness, String rack, List<Replica> replicas) {
        final double deviation = (double)this.rackSizeMap().get(rack).longValue() - fairness.rackFairValue();
        Collections.sort(replicas, new Comparator<Replica>(){

            @Override
            public int compare(Replica r1, Replica r2) {
                long c1 = context.partitionSize(r1.topicPartition());
                long c2 = context.partitionSize(r2.topicPartition());
                int result = Double.compare(Math.abs((double)c1 - deviation), Math.abs((double)c2 - deviation));
                if (result != 0) {
                    return result;
                }
                if (c1 != c2) {
                    return Long.compare(c1, c2);
                }
                if (r1.broker().id() != r2.broker().id()) {
                    return Integer.compare(r1.broker().id(), r2.broker().id());
                }
                return TopologyUtils.topicPartitionComparator.compare(r1.topicPartition(), r2.topicPartition());
            }
        });
    }

    private Map<String, Long> rackSizeMap() {
        if (this.rackSizeMap == null) {
            this.rackSizeMap = TopologyUtils.rackSizes(this.context, null, this.topic);
        }
        return this.rackSizeMap;
    }

    @Override
    protected List<Broker> createBrokersWithBelowParLeaderMetric(RebalanceContext context, LeaderFairness fairness, String topic) {
        ArrayList<Broker> result = new ArrayList<Broker>();
        for (String rack : fairness.belowParRacks()) {
            result.addAll(TopologyUtils.sortBrokersByLeadersSize(context, TopologyUtils.availableBrokersOnRack(context, rack), topic));
        }
        return result;
    }

    @Override
    protected List<Broker> createBrokersWithBelowParReplicaMetric(RebalanceContext context, ReplicaFairness fairness, String topic) {
        ArrayList<Broker> result = new ArrayList<Broker>();
        for (String rack : fairness.belowParRacks()) {
            result.addAll(TopologyUtils.sortBrokersBySize(context, TopologyUtils.availableBrokersOnRack(context, rack), topic));
        }
        return result;
    }

    @Override
    public ClusterView refresh(RebalanceContext context) {
        return new RackSizeFairView(context, this.topic);
    }
}

