/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.utils;

import io.confluent.common.security.utils.PemUtils;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PemUtilsTest {
    @Test
    public void testLoadPublicKey() throws Exception {
        InputStream resourceAsStream = this.getClass().getResourceAsStream("/publickey.pem");
        PublicKey publicKey = PemUtils.loadPublicKey((InputStream)resourceAsStream);
        Assertions.assertEquals((Object)"RSA", (Object)publicKey.getAlgorithm());
        Assertions.assertEquals((Object)"X.509", (Object)publicKey.getFormat());
    }

    @Test
    public void testWritePublicKey() throws Exception {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
        generator.initialize(2048);
        KeyPair keyPair = generator.generateKeyPair();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PemUtils.writePublicKey((OutputStream)out, (PublicKey)keyPair.getPublic());
        String outputString = out.toString("utf8");
        Assertions.assertTrue((boolean)outputString.startsWith("-----BEGIN PUBLIC KEY-----\n"));
        Assertions.assertTrue((boolean)outputString.endsWith("-----END PUBLIC KEY-----\n"));
    }

    @Test
    public void testReadKeyPair() throws Exception {
        PipedInputStream in = new PipedInputStream();
        final PipedOutputStream out = new PipedOutputStream(in);
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
        generator.initialize(2048);
        final KeyPair keyPair = generator.generateKeyPair();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    PemUtils.writeKeyPair((OutputStream)out, (KeyPair)keyPair);
                    out.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        KeyPair loadedKeyPair = PemUtils.loadKeyPair((InputStream)in);
        in.close();
        Assertions.assertTrue((boolean)keyPair.getPublic().equals(loadedKeyPair.getPublic()));
        Assertions.assertTrue((boolean)keyPair.getPrivate().equals(loadedKeyPair.getPrivate()));
    }
}

