/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.multitenant.SslCertificateSpecification;
import io.confluent.kafka.multitenant.Utils;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SslCertificateSpecificationTest {
    private SslCertificateSpecification sslSpec;
    private Path sslSpecPath;
    private Path tempDir;

    @BeforeEach
    public void setUp() {
        this.tempDir = TestUtils.tempDirectory().toPath();
    }

    @Test
    public void testSpecFileWithRequiredFields() {
        URL url = this.getClass().getResource("/cert_exp_may/spec.json");
        this.sslSpecPath = Paths.get(url.getPath(), new String[0]);
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            this.sslSpec = (SslCertificateSpecification)objectMapper.readValue(this.sslSpecPath.toFile(), SslCertificateSpecification.class);
        }
        catch (IOException ioe) {
            Assertions.fail((String)("Failed to read ssl specification from file " + this.sslSpecPath));
        }
        Assertions.assertEquals((Object)"PKCS12", (Object)this.sslSpec.sslKeystoreType());
        Assertions.assertEquals((Object)"mystorepassword", (Object)this.sslSpec.getSslKeystorePassword());
        Assertions.assertEquals((Object)"pkcs.p12", (Object)this.sslSpec.pkcsCertFilename());
        Assertions.assertEquals((Object)"fullchain.pem", (Object)this.sslSpec.sslPemFullchainFilename());
        Assertions.assertEquals((Object)"privkey.pem", (Object)this.sslSpec.sslPemPrivkeyFilename());
    }

    @Test
    public void testSpecFileContentMissingKeystoreTypeField() throws IOException {
        this.sslSpecPath = Utils.createSpecFile(this.tempDir, Utils.SSL_CERT_SPEC_NO_TYPE);
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            this.sslSpec = (SslCertificateSpecification)objectMapper.readValue(this.sslSpecPath.toFile(), SslCertificateSpecification.class);
        }
        catch (IOException ioe) {
            Assertions.fail((String)("Failed to read ssl specification from file " + this.sslSpecPath));
        }
        Assertions.assertNotEquals((Object)"PKCS12", (Object)this.sslSpec.sslKeystoreType());
        Assertions.assertEquals((Object)"pkcs.p12", (Object)this.sslSpec.pkcsCertFilename());
        Assertions.assertEquals((Object)"fullchain.pem", (Object)this.sslSpec.sslPemFullchainFilename());
        Assertions.assertEquals((Object)"privkey.pem", (Object)this.sslSpec.sslPemPrivkeyFilename());
    }

    @Test
    public void testSpecFileContentMissingKeystoreCertFileField() throws IOException {
        this.sslSpecPath = Utils.createSpecFile(this.tempDir, Utils.SSL_CERT_SPEC_NO_PKCSFILE);
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            this.sslSpec = (SslCertificateSpecification)objectMapper.readValue(this.sslSpecPath.toFile(), SslCertificateSpecification.class);
        }
        catch (IOException ioe) {
            Assertions.fail((String)("Failed to read ssl specification from file " + this.sslSpecPath));
        }
        Assertions.assertEquals((Object)"PKCS12", (Object)this.sslSpec.sslKeystoreType());
        Assertions.assertNotEquals((Object)"pkcs.p12", (Object)this.sslSpec.pkcsCertFilename());
        Assertions.assertEquals((Object)"fullchain.pem", (Object)this.sslSpec.sslPemFullchainFilename());
        Assertions.assertEquals((Object)"privkey.pem", (Object)this.sslSpec.sslPemPrivkeyFilename());
    }

    @Test
    public void testSpecFileContentMissingPemFilesField() throws IOException {
        this.sslSpecPath = Utils.createSpecFile(this.tempDir, Utils.SSL_CERT_SPEC_NO_PEMFILES);
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            this.sslSpec = (SslCertificateSpecification)objectMapper.readValue(this.sslSpecPath.toFile(), SslCertificateSpecification.class);
        }
        catch (IOException ioe) {
            Assertions.fail((String)("Failed to read ssl specification from file " + this.sslSpecPath));
        }
        Assertions.assertEquals((Object)"PKCS12", (Object)this.sslSpec.sslKeystoreType());
        Assertions.assertEquals((Object)"pkcs.p12", (Object)this.sslSpec.pkcsCertFilename());
        Assertions.assertNotEquals((Object)"fullchain.pem", (Object)this.sslSpec.sslPemFullchainFilename());
        Assertions.assertNotEquals((Object)"privkey.pem", (Object)this.sslSpec.sslPemPrivkeyFilename());
    }
}

