/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.multitenant.KafkaLogicalClusterMetadata;
import io.confluent.kafka.multitenant.PhysicalClusterMetadata;
import io.confluent.kafka.multitenant.Utils;
import io.confluent.kafka.multitenant.authorizer.MultiTenantAuthorizer;
import io.confluent.kafka.multitenant.integration.cluster.LogicalCluster;
import io.confluent.kafka.multitenant.integration.cluster.LogicalClusterUser;
import io.confluent.kafka.multitenant.integration.cluster.PhysicalCluster;
import io.confluent.kafka.multitenant.integration.test.IntegrationTestHarness;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Tag(value="integration")
public class DeleteTenantIntegrationTest {
    private static final Long TEST_CACHE_RELOAD_DELAY_MS = TimeUnit.SECONDS.toMillis(5L);
    private static final long TEST_MAX_WAIT_MS = TimeUnit.SECONDS.toMillis(60L);
    private IntegrationTestHarness testHarness;
    private PhysicalCluster physicalCluster;
    private LogicalCluster lc1;
    private LogicalCluster lc2;
    private PhysicalClusterMetadata metadata;
    private List<NewTopic> sampleTopics = Collections.singletonList(new NewTopic("abcd", 3, 1));
    private int adminUserId = 100;
    private Path tempDir;

    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        this.tempDir = TestUtils.tempDirectory().toPath();
        Utils.createLogicalClusterFile(Utils.LC_META_ABC, this.tempDir);
        Utils.createLogicalClusterFile(Utils.LC_META_XYZ, this.tempDir);
        this.testHarness = new IntegrationTestHarness(testInfo);
        this.physicalCluster = this.testHarness.start(this.nodeProps(), this.nodeProps());
        this.lc1 = this.physicalCluster.createLogicalCluster(Utils.LC_META_ABC.logicalClusterId(), this.adminUserId, 9, 11, 12);
        this.lc2 = this.physicalCluster.createLogicalCluster(Utils.LC_META_XYZ.logicalClusterId(), this.adminUserId, 9, 11, 12);
        this.metadata = this.getPhysicalClusterMetadata(this.physicalCluster);
        TestUtils.waitForCondition(() -> this.metadata.logicalClusterIds().size() == 2, (String)"Expected metadata of new logical cluster to be present in metadata cache");
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.testHarness.shutdown();
    }

    private Properties nodeProps() throws IOException {
        Properties props = new Properties();
        props.put("multitenant.metadata.dir", this.tempDir.toRealPath(new LinkOption[0]).toString());
        props.put("multitenant.metadata.class", "io.confluent.kafka.multitenant.PhysicalClusterMetadata");
        props.put(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), MultiTenantAuthorizer.class.getName());
        props.put("confluent.max.acls.per.tenant", "100");
        props.put("multitenant.metadata.reload.delay.ms", TEST_CACHE_RELOAD_DELAY_MS);
        props.put("multitenant.tenant.delete.delay", "0");
        props.put("confluent.close.connections.on.credential.delete", "true");
        return props;
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteSingleTenantWithOneTopic(String quorum) throws InterruptedException, IOException, ExecutionException {
        AdminClient adminClient1 = this.testHarness.createAdminClient(this.lc1.adminUser());
        AdminClient adminClient2 = this.testHarness.createAdminClient(this.lc2.adminUser());
        adminClient1.createTopics(this.sampleTopics).all().get();
        adminClient2.createTopics(this.sampleTopics).all().get();
        this.testHarness.ensureKraftMetadataConsistent();
        List expectedTopics = this.sampleTopics.stream().map(NewTopic::name).collect(Collectors.toList());
        Assertions.assertTrue((boolean)((Set)adminClient1.listTopics().names().get()).containsAll(expectedTopics));
        Assertions.assertTrue((boolean)((Set)adminClient2.listTopics().names().get()).containsAll(expectedTopics));
        KafkaLogicalClusterMetadata deleted = this.deleteLogicalCluster(Utils.LC_META_ABC);
        TestUtils.waitForCondition(() -> !this.metadata.logicalClusterIds().contains(deleted.logicalClusterId()), (long)TEST_MAX_WAIT_MS, (String)"Expect that the tenant is gone");
        TestUtils.waitForCondition(() -> {
            try {
                return ((Set)adminClient2.listTopics().names().get()).containsAll(expectedTopics);
            }
            catch (Exception e) {
                return false;
            }
        }, (long)TEST_MAX_WAIT_MS, (String)"Expecting the topics to be present in other cluster");
        TestUtils.waitForCondition(() -> {
            try {
                return ((Set)adminClient1.listTopics().names().get()).size() == 0;
            }
            catch (Exception e) {
                return false;
            }
        }, (long)TEST_MAX_WAIT_MS, (String)"Expecting that the tenant topics were deleted");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testTenantDeleteWhileClusterIsDown(String quorum) throws Exception {
        AdminClient adminClient1 = this.testHarness.createAdminClient(this.lc1.adminUser());
        AdminClient adminClient2 = this.testHarness.createAdminClient(this.lc2.adminUser());
        adminClient1.createTopics(this.sampleTopics).all().get();
        adminClient2.createTopics(this.sampleTopics).all().get();
        this.testHarness.ensureKraftMetadataConsistent();
        List expectedTopics = this.sampleTopics.stream().map(NewTopic::name).collect(Collectors.toList());
        Assertions.assertTrue((boolean)((Set)adminClient1.listTopics().names().get()).containsAll(expectedTopics));
        Assertions.assertTrue((boolean)((Set)adminClient2.listTopics().names().get()).containsAll(expectedTopics));
        this.testHarness.shutdownBrokers();
        KafkaLogicalClusterMetadata deleted = this.deleteLogicalCluster(Utils.LC_META_ABC);
        this.testHarness.startBrokers(this.nodeProps(), this.nodeProps());
        this.metadata = this.getPhysicalClusterMetadata(this.physicalCluster);
        AdminClient adminClient11 = this.testHarness.createAdminClient(this.lc1.adminUser());
        AdminClient adminClient22 = this.testHarness.createAdminClient(this.lc2.adminUser());
        Assertions.assertFalse((boolean)this.metadata.logicalClusterIds().contains(deleted.logicalClusterId()));
        TestUtils.waitForCondition(() -> {
            try {
                return ((Set)adminClient11.listTopics().names().get()).size() == 0;
            }
            catch (Exception e) {
                return false;
            }
        }, (long)TEST_MAX_WAIT_MS, (String)"Expecting that the tenant topics were deleted");
        TestUtils.waitForCondition(() -> {
            try {
                return ((Set)adminClient22.listTopics().names().get()).size() > 0;
            }
            catch (Exception e) {
                return false;
            }
        }, (long)TEST_MAX_WAIT_MS, (String)"Expecting non zero tenant topics count.");
        Set topics = (Set)adminClient22.listTopics().names().get();
        Assertions.assertTrue((boolean)topics.containsAll(expectedTopics), (String)("topics: " + topics + ", expected Topics: " + expectedTopics));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteSingleTenantWithACLs(String quorum) throws InterruptedException, IOException, ExecutionException {
        LogicalClusterUser user = this.lc1.user(9);
        LogicalClusterUser user2 = this.lc2.user(11);
        this.testHarness.newAclCommand().produceAclArgs(user.prefixedKafkaPrincipal(), user.withPrefix("topic1"), PatternType.LITERAL).execute();
        this.testHarness.newAclCommand().consumeAclArgs(user.prefixedKafkaPrincipal(), user.withPrefix("topic2."), user.withPrefix("group"), PatternType.PREFIXED).execute();
        this.testHarness.newAclCommand().produceAclArgs(user2.prefixedKafkaPrincipal(), user2.withPrefix("topic1"), PatternType.LITERAL).execute();
        AdminClient superClient = this.physicalCluster.superAdminClient();
        Collection describedAcls = (Collection)superClient.describeAcls(new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, null, PatternType.ANY), new AccessControlEntryFilter(null, null, AclOperation.ANY, AclPermissionType.ANY))).values().get();
        Assertions.assertTrue((describedAcls.size() > 0 ? 1 : 0) != 0, (String)"ACLs should exist");
        KafkaLogicalClusterMetadata deleted = this.deleteLogicalCluster(Utils.LC_META_ABC);
        TestUtils.waitForCondition(() -> !this.metadata.logicalClusterIds().contains(deleted.logicalClusterId()), (long)TEST_MAX_WAIT_MS, (String)"Expect that the tenant is gone");
        TestUtils.waitForCondition(() -> {
            try {
                return ((Collection)superClient.describeAcls(new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, null, PatternType.ANY), new AccessControlEntryFilter(user.prefixedKafkaPrincipal().toString(), null, AclOperation.ANY, AclPermissionType.ANY))).values().get()).size() == 0;
            }
            catch (Exception e) {
                return false;
            }
        }, (long)TEST_MAX_WAIT_MS, (String)"Expecting that the tenant ACLs were deleted");
        describedAcls.clear();
        describedAcls = (Collection)superClient.describeAcls(new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, null, PatternType.ANY), new AccessControlEntryFilter(user2.prefixedKafkaPrincipal().toString(), null, AclOperation.ANY, AclPermissionType.ANY))).values().get();
        Assertions.assertTrue((describedAcls.size() > 0 ? 1 : 0) != 0, (String)"ACLs should exist");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testHandleACLsDisabledCase(String quorum) throws Exception {
        Properties props = new Properties();
        props.put(KafkaConfig.BrokerIdProp(), (Object)100);
        props.put("multitenant.metadata.dir", this.tempDir.toRealPath(new LinkOption[0]).toString());
        props.put("multitenant.metadata.class", "io.confluent.kafka.multitenant.PhysicalClusterMetadata");
        props.put(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), MultiTenantAuthorizer.class.getName());
        props.put("multitenant.metadata.reload.delay.ms", TEST_CACHE_RELOAD_DELAY_MS);
        props.put("multitenant.tenant.delete.delay", "0");
        this.testHarness.shutdown();
        PhysicalCluster physicalCluster = this.testHarness.start(props);
        PhysicalClusterMetadata metadata = this.getPhysicalClusterMetadata(physicalCluster);
        Utils.createLogicalClusterFile(Utils.LC_META_ABC, this.tempDir);
        KafkaLogicalClusterMetadata deleted1 = this.deleteLogicalCluster(Utils.LC_META_ABC);
        TestUtils.waitForCondition(() -> metadata.tenantLifecycleManager.fullyDeletedClusters().contains(deleted1.logicalClusterId()), (long)TEST_MAX_WAIT_MS, (String)"Expect that the tenants are gone");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDelayedDelete(String quorum) throws Exception {
        int delaySec = 10;
        Properties props = new Properties();
        props.put(KafkaConfig.BrokerIdProp(), (Object)100);
        props.put("multitenant.metadata.dir", this.tempDir.toRealPath(new LinkOption[0]).toString());
        props.put("multitenant.metadata.class", "io.confluent.kafka.multitenant.PhysicalClusterMetadata");
        props.put(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), MultiTenantAuthorizer.class.getName());
        props.put("multitenant.metadata.reload.delay.ms", TEST_CACHE_RELOAD_DELAY_MS);
        props.put("multitenant.tenant.delete.delay", (Object)TimeUnit.SECONDS.toMillis(delaySec));
        this.testHarness.shutdown();
        PhysicalCluster physicalCluster = this.testHarness.start(props);
        PhysicalClusterMetadata metadata = this.getPhysicalClusterMetadata(physicalCluster);
        Utils.createLogicalClusterFile(Utils.LC_META_ABC, this.tempDir);
        TestUtils.waitForCondition(() -> metadata.logicalClusterIds().contains(Utils.LC_META_ABC.logicalClusterId()), (long)TEST_MAX_WAIT_MS, (String)"Tenant wasn't created on time");
        KafkaLogicalClusterMetadata deleted = this.deleteLogicalCluster(Utils.LC_META_ABC);
        TestUtils.waitForCondition(() -> !metadata.logicalClusterIds().contains(deleted.logicalClusterId()) && !metadata.tenantLifecycleManager.deletedClusters().contains(deleted.logicalClusterId()), (long)TEST_MAX_WAIT_MS, (String)"Tenant should not be part of the cache but not deleted either");
        TestUtils.waitForCondition(() -> metadata.tenantLifecycleManager.fullyDeletedClusters().contains(deleted.logicalClusterId()), (long)TEST_MAX_WAIT_MS, (String)"Tenant was not deleted as expected");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteCredentials(String quorum) throws Exception {
        AdminClient adminClient1 = this.testHarness.createAdminClient(this.lc1.adminUser());
        AdminClient adminClient2 = this.testHarness.createAdminClient(this.lc2.adminUser());
        adminClient1.createTopics(this.sampleTopics).all().get();
        adminClient2.createTopics(this.sampleTopics).all().get();
        this.testHarness.ensureKraftMetadataConsistent();
        List expectedTopics = this.sampleTopics.stream().map(NewTopic::name).collect(Collectors.toList());
        Assertions.assertTrue((boolean)((Set)adminClient1.listTopics().names().get()).containsAll(expectedTopics));
        Assertions.assertTrue((boolean)((Set)adminClient2.listTopics().names().get()).containsAll(expectedTopics));
        this.lc1.deleteUserCredential(this.lc1.adminUser());
        TestUtils.waitForCondition(() -> {
            try {
                adminClient1.listTopics(new ListTopicsOptions().timeoutMs(Integer.valueOf(5000))).names().get(10L, TimeUnit.SECONDS);
                return false;
            }
            catch (ExecutionException e) {
                return e.getCause() instanceof AuthenticationException;
            }
        }, (long)15000L, (String)"Expected connections to fail authentication");
        Assertions.assertTrue((boolean)((Set)adminClient2.listTopics().names().get()).containsAll(expectedTopics));
    }

    private KafkaLogicalClusterMetadata deleteLogicalCluster(KafkaLogicalClusterMetadata lkc) throws IOException {
        KafkaLogicalClusterMetadata deleted = new KafkaLogicalClusterMetadata(lkc.logicalClusterId(), lkc.physicalClusterId(), lkc.logicalClusterName(), lkc.accountId(), lkc.k8sClusterId(), lkc.logicalClusterType(), lkc.storageBytes(), lkc.producerByteRate(), lkc.consumerByteRate(), null, null, Long.valueOf(lkc.brokerRequestPercentage().longValue()), lkc.networkQuotaOverhead(), new KafkaLogicalClusterMetadata.LifecycleMetadata(lkc.lifecycleMetadata().logicalClusterName(), lkc.lifecycleMetadata().physicalK8sNamespace(), lkc.lifecycleMetadata().creationDate(), new Date()), null, lkc.organizationId(), lkc.environmentId());
        Utils.updateLogicalClusterFile(deleted, this.tempDir);
        return deleted;
    }

    private PhysicalClusterMetadata getPhysicalClusterMetadata(PhysicalCluster physicalCluster) {
        PhysicalClusterMetadata metadata = (PhysicalClusterMetadata)physicalCluster.kafkaCluster().kafkaBrokers().get(0).multiTenantMetadata().get();
        return metadata;
    }
}

