/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.streamingaead;

import com.google.crypto.tink.StreamingAead;
import com.google.crypto.tink.internal.LegacyProtoKey;
import com.google.crypto.tink.internal.MutablePrimitiveRegistry;
import com.google.crypto.tink.internal.PrimitiveConstructor;
import com.google.crypto.tink.internal.PrimitiveRegistry;
import com.google.crypto.tink.internal.PrimitiveSet;
import com.google.crypto.tink.internal.PrimitiveWrapper;
import com.google.crypto.tink.streamingaead.StreamingAeadHelper;
import com.google.crypto.tink.streamingaead.internal.LegacyFullStreamingAead;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;

public class StreamingAeadWrapper
implements PrimitiveWrapper<StreamingAead, StreamingAead> {
    private static final StreamingAeadWrapper WRAPPER = new StreamingAeadWrapper();
    private static final PrimitiveConstructor<LegacyProtoKey, StreamingAead> LEGACY_FULL_STREAMING_AEAD_PRIMITIVE_CONSTRUCTOR = PrimitiveConstructor.create(LegacyFullStreamingAead::create, LegacyProtoKey.class, StreamingAead.class);

    StreamingAeadWrapper() {
    }

    @Override
    public StreamingAead wrap(PrimitiveSet<StreamingAead> primitives) throws GeneralSecurityException {
        ArrayList<StreamingAead> allStreamingAeads = new ArrayList<StreamingAead>();
        for (List<PrimitiveSet.Entry<StreamingAead>> entryList : primitives.getAll()) {
            for (PrimitiveSet.Entry<StreamingAead> entry : entryList) {
                if (entry.getFullPrimitive() == null) {
                    throw new GeneralSecurityException("No full primitive set for key id " + entry.getKeyId());
                }
                allStreamingAeads.add(entry.getFullPrimitive());
            }
        }
        PrimitiveSet.Entry<StreamingAead> primary = primitives.getPrimary();
        if (primary == null || primary.getFullPrimitive() == null) {
            throw new GeneralSecurityException("No primary set");
        }
        return new StreamingAeadHelper(allStreamingAeads, primary.getFullPrimitive());
    }

    @Override
    public Class<StreamingAead> getPrimitiveClass() {
        return StreamingAead.class;
    }

    @Override
    public Class<StreamingAead> getInputPrimitiveClass() {
        return StreamingAead.class;
    }

    public static void register() throws GeneralSecurityException {
        MutablePrimitiveRegistry.globalInstance().registerPrimitiveWrapper(WRAPPER);
        MutablePrimitiveRegistry.globalInstance().registerPrimitiveConstructor(LEGACY_FULL_STREAMING_AEAD_PRIMITIVE_CONSTRUCTOR);
    }

    public static void registerToInternalPrimitiveRegistry(PrimitiveRegistry.Builder primitiveRegistryBuilder) throws GeneralSecurityException {
        primitiveRegistryBuilder.registerPrimitiveWrapper(WRAPPER);
    }
}

