/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.consumer;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.consumer.ClientAssignor;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataValue;

public class ConsumerGroupMember {
    private final String memberId;
    private final int memberEpoch;
    private final int previousMemberEpoch;
    private final int nextMemberEpoch;
    private final String instanceId;
    private final String rackId;
    private final int rebalanceTimeoutMs;
    private final String clientId;
    private final String clientHost;
    private final List<String> subscribedTopicNames;
    private final String subscribedTopicRegex;
    private final String serverAssignorName;
    private final List<ClientAssignor> clientAssignors;
    private final MemberState state;
    private final Map<Uuid, Set<Integer>> assignedPartitions;
    private final Map<Uuid, Set<Integer>> partitionsPendingRevocation;
    private final Map<Uuid, Set<Integer>> partitionsPendingAssignment;

    private ConsumerGroupMember(String memberId, int memberEpoch, int previousMemberEpoch, int nextMemberEpoch, String instanceId, String rackId, int rebalanceTimeoutMs, String clientId, String clientHost, List<String> subscribedTopicNames, String subscribedTopicRegex, String serverAssignorName, List<ClientAssignor> clientAssignors, MemberState state, Map<Uuid, Set<Integer>> assignedPartitions, Map<Uuid, Set<Integer>> partitionsPendingRevocation, Map<Uuid, Set<Integer>> partitionsPendingAssignment) {
        this.memberId = memberId;
        this.memberEpoch = memberEpoch;
        this.previousMemberEpoch = previousMemberEpoch;
        this.nextMemberEpoch = nextMemberEpoch;
        this.instanceId = instanceId;
        this.rackId = rackId;
        this.rebalanceTimeoutMs = rebalanceTimeoutMs;
        this.clientId = clientId;
        this.clientHost = clientHost;
        this.subscribedTopicNames = subscribedTopicNames;
        this.subscribedTopicRegex = subscribedTopicRegex;
        this.serverAssignorName = serverAssignorName;
        this.clientAssignors = clientAssignors;
        this.state = state;
        this.assignedPartitions = assignedPartitions;
        this.partitionsPendingRevocation = partitionsPendingRevocation;
        this.partitionsPendingAssignment = partitionsPendingAssignment;
    }

    public String memberId() {
        return this.memberId;
    }

    public int memberEpoch() {
        return this.memberEpoch;
    }

    public int previousMemberEpoch() {
        return this.previousMemberEpoch;
    }

    public int nextMemberEpoch() {
        return this.nextMemberEpoch;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String rackId() {
        return this.rackId;
    }

    public int rebalanceTimeoutMs() {
        return this.rebalanceTimeoutMs;
    }

    public String clientId() {
        return this.clientId;
    }

    public String clientHost() {
        return this.clientHost;
    }

    public List<String> subscribedTopicNames() {
        return this.subscribedTopicNames;
    }

    public String subscribedTopicRegex() {
        return this.subscribedTopicRegex;
    }

    public Optional<String> serverAssignorName() {
        return Optional.ofNullable(this.serverAssignorName);
    }

    public List<ClientAssignor> clientAssignors() {
        return this.clientAssignors;
    }

    public MemberState state() {
        return this.state;
    }

    public Map<Uuid, Set<Integer>> assignedPartitions() {
        return this.assignedPartitions;
    }

    public Map<Uuid, Set<Integer>> partitionsPendingRevocation() {
        return this.partitionsPendingRevocation;
    }

    public Map<Uuid, Set<Integer>> partitionsPendingAssignment() {
        return this.partitionsPendingAssignment;
    }

    public String currentAssignmentSummary() {
        return "CurrentAssignment(, memberEpoch=" + this.memberEpoch + ", previousMemberEpoch=" + this.previousMemberEpoch + ", nextMemberEpoch=" + this.nextMemberEpoch + ", state=" + (Object)((Object)this.state) + ", assignedPartitions=" + this.assignedPartitions + ", partitionsPendingRevocation=" + this.partitionsPendingRevocation + ", partitionsPendingAssignment=" + this.partitionsPendingAssignment + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsumerGroupMember that = (ConsumerGroupMember)o;
        return this.memberEpoch == that.memberEpoch && this.previousMemberEpoch == that.previousMemberEpoch && this.nextMemberEpoch == that.nextMemberEpoch && this.rebalanceTimeoutMs == that.rebalanceTimeoutMs && Objects.equals(this.memberId, that.memberId) && Objects.equals(this.instanceId, that.instanceId) && Objects.equals(this.rackId, that.rackId) && Objects.equals(this.clientId, that.clientId) && Objects.equals(this.clientHost, that.clientHost) && Objects.equals(this.subscribedTopicNames, that.subscribedTopicNames) && Objects.equals(this.subscribedTopicRegex, that.subscribedTopicRegex) && Objects.equals(this.serverAssignorName, that.serverAssignorName) && Objects.equals(this.clientAssignors, that.clientAssignors) && Objects.equals(this.assignedPartitions, that.assignedPartitions) && Objects.equals(this.partitionsPendingRevocation, that.partitionsPendingRevocation) && Objects.equals(this.partitionsPendingAssignment, that.partitionsPendingAssignment);
    }

    public int hashCode() {
        int result = this.memberId != null ? this.memberId.hashCode() : 0;
        result = 31 * result + this.memberEpoch;
        result = 31 * result + this.previousMemberEpoch;
        result = 31 * result + this.nextMemberEpoch;
        result = 31 * result + Objects.hashCode(this.instanceId);
        result = 31 * result + Objects.hashCode(this.rackId);
        result = 31 * result + this.rebalanceTimeoutMs;
        result = 31 * result + Objects.hashCode(this.clientId);
        result = 31 * result + Objects.hashCode(this.clientHost);
        result = 31 * result + Objects.hashCode(this.subscribedTopicNames);
        result = 31 * result + Objects.hashCode(this.subscribedTopicRegex);
        result = 31 * result + Objects.hashCode(this.serverAssignorName);
        result = 31 * result + Objects.hashCode(this.clientAssignors);
        result = 31 * result + Objects.hashCode(this.assignedPartitions);
        result = 31 * result + Objects.hashCode(this.partitionsPendingRevocation);
        result = 31 * result + Objects.hashCode(this.partitionsPendingAssignment);
        return result;
    }

    public String toString() {
        return "ConsumerGroupMember(memberId='" + this.memberId + '\'' + ", memberEpoch=" + this.memberEpoch + ", previousMemberEpoch=" + this.previousMemberEpoch + ", nextMemberEpoch=" + this.nextMemberEpoch + ", instanceId='" + this.instanceId + '\'' + ", rackId='" + this.rackId + '\'' + ", rebalanceTimeoutMs=" + this.rebalanceTimeoutMs + ", clientId='" + this.clientId + '\'' + ", clientHost='" + this.clientHost + '\'' + ", subscribedTopicNames=" + this.subscribedTopicNames + ", subscribedTopicRegex='" + this.subscribedTopicRegex + '\'' + ", serverAssignorName='" + this.serverAssignorName + '\'' + ", clientAssignors=" + this.clientAssignors + ", state=" + (Object)((Object)this.state) + ", assignedPartitions=" + this.assignedPartitions + ", partitionsPendingRevocation=" + this.partitionsPendingRevocation + ", partitionsPendingAssignment=" + this.partitionsPendingAssignment + ')';
    }

    public static enum MemberState {
        REVOKING("revoking"),
        ASSIGNING("assigning"),
        STABLE("stable");

        private final String name;

        private MemberState(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Builder {
        private final String memberId;
        private int memberEpoch = 0;
        private int previousMemberEpoch = -1;
        private int nextMemberEpoch = 0;
        private String instanceId = null;
        private String rackId = null;
        private int rebalanceTimeoutMs = -1;
        private String clientId = "";
        private String clientHost = "";
        private List<String> subscribedTopicNames = Collections.emptyList();
        private String subscribedTopicRegex = "";
        private String serverAssignorName = null;
        private List<ClientAssignor> clientAssignors = Collections.emptyList();
        private Map<Uuid, Set<Integer>> assignedPartitions = Collections.emptyMap();
        private Map<Uuid, Set<Integer>> partitionsPendingRevocation = Collections.emptyMap();
        private Map<Uuid, Set<Integer>> partitionsPendingAssignment = Collections.emptyMap();

        public Builder(String memberId) {
            this.memberId = Objects.requireNonNull(memberId);
        }

        public Builder(ConsumerGroupMember member) {
            Objects.requireNonNull(member);
            this.memberId = member.memberId;
            this.memberEpoch = member.memberEpoch;
            this.previousMemberEpoch = member.previousMemberEpoch;
            this.nextMemberEpoch = member.nextMemberEpoch;
            this.instanceId = member.instanceId;
            this.rackId = member.rackId;
            this.rebalanceTimeoutMs = member.rebalanceTimeoutMs;
            this.clientId = member.clientId;
            this.clientHost = member.clientHost;
            this.subscribedTopicNames = member.subscribedTopicNames;
            this.subscribedTopicRegex = member.subscribedTopicRegex;
            this.serverAssignorName = member.serverAssignorName;
            this.clientAssignors = member.clientAssignors;
            this.assignedPartitions = member.assignedPartitions;
            this.partitionsPendingRevocation = member.partitionsPendingRevocation;
            this.partitionsPendingAssignment = member.partitionsPendingAssignment;
        }

        public Builder setMemberEpoch(int memberEpoch) {
            this.memberEpoch = memberEpoch;
            return this;
        }

        public Builder setPreviousMemberEpoch(int previousMemberEpoch) {
            this.previousMemberEpoch = previousMemberEpoch;
            return this;
        }

        public Builder setNextMemberEpoch(int nextMemberEpoch) {
            this.nextMemberEpoch = nextMemberEpoch;
            return this;
        }

        public Builder setInstanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder maybeUpdateInstanceId(Optional<String> instanceId) {
            this.instanceId = instanceId.orElse(this.instanceId);
            return this;
        }

        public Builder setRackId(String rackId) {
            this.rackId = rackId;
            return this;
        }

        public Builder maybeUpdateRackId(Optional<String> rackId) {
            this.rackId = rackId.orElse(this.rackId);
            return this;
        }

        public Builder setRebalanceTimeoutMs(int rebalanceTimeoutMs) {
            this.rebalanceTimeoutMs = rebalanceTimeoutMs;
            return this;
        }

        public Builder maybeUpdateRebalanceTimeoutMs(OptionalInt rebalanceTimeoutMs) {
            this.rebalanceTimeoutMs = rebalanceTimeoutMs.orElse(this.rebalanceTimeoutMs);
            return this;
        }

        public Builder setClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder setClientHost(String clientHost) {
            this.clientHost = clientHost;
            return this;
        }

        public Builder setSubscribedTopicNames(List<String> subscribedTopicNames) {
            this.subscribedTopicNames = subscribedTopicNames;
            this.subscribedTopicNames.sort(Comparator.naturalOrder());
            return this;
        }

        public Builder maybeUpdateSubscribedTopicNames(Optional<List<String>> subscribedTopicNames) {
            this.subscribedTopicNames = subscribedTopicNames.orElse(this.subscribedTopicNames);
            this.subscribedTopicNames.sort(Comparator.naturalOrder());
            return this;
        }

        public Builder setSubscribedTopicRegex(String subscribedTopicRegex) {
            this.subscribedTopicRegex = subscribedTopicRegex;
            return this;
        }

        public Builder maybeUpdateSubscribedTopicRegex(Optional<String> subscribedTopicRegex) {
            this.subscribedTopicRegex = subscribedTopicRegex.orElse(this.subscribedTopicRegex);
            return this;
        }

        public Builder setServerAssignorName(String serverAssignorName) {
            this.serverAssignorName = serverAssignorName;
            return this;
        }

        public Builder maybeUpdateServerAssignorName(Optional<String> serverAssignorName) {
            this.serverAssignorName = serverAssignorName.orElse(this.serverAssignorName);
            return this;
        }

        public Builder setClientAssignors(List<ClientAssignor> clientAssignors) {
            this.clientAssignors = clientAssignors;
            return this;
        }

        public Builder maybeUpdateClientAssignors(Optional<List<ClientAssignor>> clientAssignors) {
            this.clientAssignors = clientAssignors.orElse(this.clientAssignors);
            return this;
        }

        public Builder setAssignedPartitions(Map<Uuid, Set<Integer>> assignedPartitions) {
            this.assignedPartitions = assignedPartitions;
            return this;
        }

        public Builder setPartitionsPendingRevocation(Map<Uuid, Set<Integer>> partitionsPendingRevocation) {
            this.partitionsPendingRevocation = partitionsPendingRevocation;
            return this;
        }

        public Builder setPartitionsPendingAssignment(Map<Uuid, Set<Integer>> partitionsPendingAssignment) {
            this.partitionsPendingAssignment = partitionsPendingAssignment;
            return this;
        }

        public Builder updateWith(ConsumerGroupMemberMetadataValue record) {
            this.setInstanceId(record.instanceId());
            this.setRackId(record.rackId());
            this.setClientId(record.clientId());
            this.setClientHost(record.clientHost());
            this.setSubscribedTopicNames(record.subscribedTopicNames());
            this.setSubscribedTopicRegex(record.subscribedTopicRegex());
            this.setRebalanceTimeoutMs(record.rebalanceTimeoutMs());
            this.setServerAssignorName(record.serverAssignor());
            this.setClientAssignors(record.assignors().stream().map(ClientAssignor::fromRecord).collect(Collectors.toList()));
            return this;
        }

        public Builder updateWith(ConsumerGroupCurrentMemberAssignmentValue record) {
            this.setMemberEpoch(record.memberEpoch());
            this.setPreviousMemberEpoch(record.previousMemberEpoch());
            this.setNextMemberEpoch(record.targetMemberEpoch());
            this.setAssignedPartitions(this.assignmentFromTopicPartitions(record.assignedPartitions()));
            this.setPartitionsPendingRevocation(this.assignmentFromTopicPartitions(record.partitionsPendingRevocation()));
            this.setPartitionsPendingAssignment(this.assignmentFromTopicPartitions(record.partitionsPendingAssignment()));
            return this;
        }

        private Map<Uuid, Set<Integer>> assignmentFromTopicPartitions(List<ConsumerGroupCurrentMemberAssignmentValue.TopicPartitions> topicPartitionsList) {
            return topicPartitionsList.stream().collect(Collectors.toMap(ConsumerGroupCurrentMemberAssignmentValue.TopicPartitions::topicId, topicPartitions -> Collections.unmodifiableSet(new HashSet<Integer>(topicPartitions.partitions()))));
        }

        public ConsumerGroupMember build() {
            MemberState state = !this.partitionsPendingRevocation.isEmpty() ? MemberState.REVOKING : (!this.partitionsPendingAssignment.isEmpty() ? MemberState.ASSIGNING : MemberState.STABLE);
            return new ConsumerGroupMember(this.memberId, this.memberEpoch, this.previousMemberEpoch, this.nextMemberEpoch, this.instanceId, this.rackId, this.rebalanceTimeoutMs, this.clientId, this.clientHost, this.subscribedTopicNames, this.subscribedTopicRegex, this.serverAssignorName, this.clientAssignors, state, this.assignedPartitions, this.partitionsPendingRevocation, this.partitionsPendingAssignment);
        }
    }
}

