/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.logevents.connect;

import com.google.common.base.Throwables;
import io.confluent.crn.ConfluentResourceName;
import io.confluent.crn.CrnSyntaxException;
import io.confluent.logevents.connect.ConnectLogEntry;
import io.confluent.logevents.connect.Context;
import io.confluent.logevents.connect.LogEventState;
import io.confluent.logevents.connect.LogEventsEmitter;
import io.confluent.logevents.connect.Summary;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogEvents {
    private static final String CONNECTOR_SOURCE_NAME = "connector";
    private static final Logger log = LoggerFactory.getLogger(LogEvents.class);

    public static void connectorFailedEvent(Supplier<LogEventsEmitter> logEventsEmitterSupplier, String connectorId, Throwable cause, Optional<LogEventState> logEventStateOptional) {
        LogEvents.validateArguments(logEventsEmitterSupplier, connectorId, cause);
        if (!logEventStateOptional.isPresent() || logEventStateOptional.get().logFailureEvent(cause)) {
            LogEvents.emitLogEntry(logEventsEmitterSupplier, connectorId, cause, EventType.CONNECTOR_FAILED, connectorId);
        } else {
            log.trace("Skipping emission of duplicate Connector failure log event for connector: {}", (Object)connectorId);
        }
    }

    public static void connectorTaskFailedEvent(Supplier<LogEventsEmitter> logEventsEmitterSupplier, String connectorId, String taskId, Throwable cause, Optional<LogEventState> logEventStateOptional) {
        LogEvents.validateArguments(logEventsEmitterSupplier, connectorId, cause);
        Objects.requireNonNull(taskId, "taskId");
        if (!logEventStateOptional.isPresent() || logEventStateOptional.get().logFailureEvent(cause)) {
            LogEvents.emitLogEntry(logEventsEmitterSupplier, connectorId, cause, EventType.TASK_FAILED, connectorId + "-" + taskId);
        } else {
            log.trace("Skipping emission of Connector Task failure log event for task: {}", (Object)(connectorId + "-" + taskId));
        }
    }

    public static LogEventState createLogEventState(Function<Map.Entry<String, LogEventState>, LogEventState> createLogEventStateIfAbsent, String id, long logFailureEventResetTime) {
        Map.Entry logEventStateEntry = Utils.mkEntry((Object)id, (Object)new LogEventState(id, logFailureEventResetTime, Time.SYSTEM));
        return createLogEventStateIfAbsent.apply(logEventStateEntry);
    }

    private static void validateArguments(Supplier<LogEventsEmitter> logEventsEmitterSupplier, String connectorId, Throwable cause) {
        Objects.requireNonNull(logEventsEmitterSupplier, "logEventsEmitterSupplier");
        Objects.requireNonNull(cause, "cause");
        Objects.requireNonNull(connectorId, "connectorId should not be null or empty");
    }

    private static void emitLogEntry(Supplier<LogEventsEmitter> connectLogEventsProviderSupplier, String connectorId, Throwable cause, EventType eventType, String subject) {
        ConnectLogEntry connectLogEntry = LogEvents.constructLogEntry(connectorId, eventType, cause);
        try {
            connectLogEventsProviderSupplier.get().emit(connectLogEntry, subject, LogEvents.sourceCRN(CONNECTOR_SOURCE_NAME, connectorId), eventType.toString());
        }
        catch (CrnSyntaxException e) {
            log.error("Unable to create CRN for source: {}. Skipping Connect Log Event {}", (Object)connectorId, (Object)connectLogEntry);
        }
    }

    private static ConnectLogEntry constructLogEntry(String connectorId, EventType eventType, Throwable cause) {
        ConnectLogEntry.Builder logEntryBuilder = ConnectLogEntry.newBuilder();
        Summary.Builder summaryBuilder = Summary.newBuilder();
        switch (eventType) {
            case CONNECTOR_FAILED: 
            case TASK_FAILED: {
                Summary.ConnectorErrorSummary.Builder connectorErrorSummaryBuilder = Summary.ConnectorErrorSummary.newBuilder();
                if (cause.getMessage() != null) {
                    connectorErrorSummaryBuilder.setMessage(cause.getMessage());
                }
                try {
                    Throwable rootCause = Throwables.getRootCause((Throwable)cause);
                    if (rootCause.getMessage() != null) {
                        connectorErrorSummaryBuilder.setRootCause(rootCause.getMessage());
                    }
                }
                catch (IllegalArgumentException e) {
                    log.warn("Exception loop found, not setting root cause in connect log entry.", (Throwable)e);
                }
                summaryBuilder.setConnectorErrorSummary(connectorErrorSummaryBuilder);
                break;
            }
        }
        logEntryBuilder.setLevel(eventType.level().toString()).setSummary(summaryBuilder).setContext(Context.newBuilder().setConnectorId(connectorId));
        return logEntryBuilder.build();
    }

    private static String sourceCRN(String sourceName, String sourceId) throws CrnSyntaxException {
        ConfluentResourceName sourceCRN = ConfluentResourceName.newBuilder().setAuthority("confluent.cloud").addElement(sourceName, sourceId).build();
        return sourceCRN.toString();
    }

    static enum EventType {
        CONNECTOR_STARTED("ConnectorStarted", Level.INFO),
        CONNECTOR_PAUSED("ConnectorPaused", Level.INFO),
        CONNECTOR_RESUMED("ConnectorResumed", Level.INFO),
        CONNECTOR_FAILED("ConnectorFailed", Level.ERROR),
        CONNECTOR_SHUTDOWN("ConnectorShutdown", Level.INFO),
        CONNECTOR_DELETED("ConnectorDeleted", Level.INFO),
        TASK_FAILED("TaskFailed", Level.ERROR);

        private static final String NAMESPACE_PREFIX = "io.confluent.logevents.connect.";
        private final String canonicalType;
        private final Level level;

        private EventType(String canonicalType, Level level) {
            this.canonicalType = NAMESPACE_PREFIX + canonicalType;
            this.level = level;
        }

        public String toString() {
            return this.canonicalType;
        }

        public Level level() {
            return this.level;
        }

        static enum Level {
            ERROR,
            INFO;

        }
    }
}

