/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import java.util.HashMap;
import java.util.Map;

public enum MirrorTopicError {
    UNKNOWN(-2),
    NOT_SET(-1),
    NO_ERROR(0),
    SOURCE_TOPIC_MAY_BE_DELETED(1),
    SOURCE_TOPIC_ID_CHANGED(2),
    SOURCE_PARTITIONS_DECREASED(3),
    NON_MONOTONIC_LOG_APPEND_EPOCH(4),
    UNEXPECTED_TRUNCATION(5),
    UNSUPPORTED_MESSAGE_FORMAT(6),
    NON_MONOTONIC_SOURCE_EPOCH(7),
    ILLEGAL_STATE(8),
    UNSUPPORTED_MIRROR_STATE(9),
    RECORD_TOO_LARGE(10);

    private static final MirrorTopicError DEFAULT_ERROR;
    private static Map<Short, MirrorTopicError> codeToError;
    private final short code;

    private MirrorTopicError(int code) {
        this.code = (short)code;
    }

    public short code() {
        return this.code;
    }

    public static MirrorTopicError forCode(short code, boolean failed) {
        MirrorTopicError error = codeToError.get(code);
        error = error != null ? error : UNKNOWN;
        return MirrorTopicError.errorOrDefault(error, failed);
    }

    public static MirrorTopicError errorOrDefault(MirrorTopicError error, boolean failed) {
        if (error == null || error == NOT_SET) {
            return failed ? DEFAULT_ERROR : NO_ERROR;
        }
        return error;
    }

    static {
        DEFAULT_ERROR = SOURCE_TOPIC_MAY_BE_DELETED;
        codeToError = new HashMap<Short, MirrorTopicError>();
        for (MirrorTopicError error : MirrorTopicError.values()) {
            if (codeToError.put(error.code, error) == null) continue;
            throw new ExceptionInInitializerError(String.format("Code %d for error %s has already been used", error.code, error.name()));
        }
    }
}

