/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.codegen.helpers;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.Pair;
import java.util.List;

public final class LambdaUtil {
    private LambdaUtil() {
    }

    public static String toJavaCode(String argName, Class<?> argType, String lambdaBody) {
        return LambdaUtil.toJavaCode(ImmutableList.of((Object)new Pair((Object)argName, argType)), lambdaBody);
    }

    public static String toJavaCode(List<Pair<String, Class<?>>> argList, String lambdaBody) {
        String functionApply;
        String functionType;
        StringBuilder arguments = new StringBuilder();
        int i = 0;
        for (Pair<String, Class<?>> argPair : argList) {
            String javaType = ((Class)argPair.right).getSimpleName();
            arguments.append("   final " + javaType + " " + (String)argPair.left + " = (" + javaType + ") arg" + ++i + ";\n");
        }
        if (argList.size() == 1) {
            functionType = "Function()";
            functionApply = " public Object apply(Object arg1) {\n";
        } else if (argList.size() == 2) {
            functionType = "BiFunction()";
            functionApply = " public Object apply(Object arg1, Object arg2) {\n";
        } else if (argList.size() == 3) {
            functionType = "TriFunction()";
            functionApply = " public Object apply(Object arg1, Object arg2, Object arg3) {\n";
        } else {
            throw new KsqlException("Unsupported number of lambda arguments.");
        }
        String function = "new " + functionType + " {\n @Override\n" + functionApply + arguments.toString() + "   return " + lambdaBody + ";\n }\n}";
        return function;
    }
}

