/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.expression.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.ExpressionVisitor;
import io.confluent.ksql.execution.expression.tree.Literal;
import io.confluent.ksql.parser.NodeLocation;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class IntegerLiteral
extends Literal {
    private final int value;

    public IntegerLiteral(int value) {
        this(Optional.empty(), value);
    }

    public IntegerLiteral(Optional<NodeLocation> location, int value) {
        super(location);
        this.value = value;
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitIntegerLiteral(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        IntegerLiteral that = (IntegerLiteral)((Object)o);
        return this.value == that.value;
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }
}

