/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.function.udaf;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.GenericRow;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.apache.kafka.streams.kstream.Initializer;

public class KudafInitializer
implements Initializer<GenericRow> {
    private final List<Supplier<?>> initialValueSuppliers;
    private final int nonAggValSize;

    public KudafInitializer(int nonAggValSize, List<Supplier<?>> initialValueSuppliers) {
        this.nonAggValSize = nonAggValSize;
        this.initialValueSuppliers = ImmutableList.copyOf((Collection)Objects.requireNonNull(initialValueSuppliers, "initialValueSuppliers"));
    }

    public GenericRow apply() {
        GenericRow row = new GenericRow(this.nonAggValSize + this.initialValueSuppliers.size());
        IntStream.range(0, this.nonAggValSize).forEach(i -> row.append(null));
        this.initialValueSuppliers.forEach(supplier -> row.append(supplier.get()));
        return row;
    }
}

