/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.plan;

import io.confluent.ksql.GenericKey;
import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.runtime.RuntimeBuildContext;
import io.confluent.ksql.schema.ksql.PhysicalSchema;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.WindowInfo;
import io.confluent.ksql.testing.EffectivelyImmutable;
import java.util.Objects;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.kstream.Windowed;

@EffectivelyImmutable
public interface ExecutionKeyFactory<K> {
    public Serde<K> buildKeySerde(FormatInfo var1, PhysicalSchema var2, QueryContext var3);

    public ExecutionKeyFactory<K> withQueryBuilder(RuntimeBuildContext var1);

    public K constructNewKey(K var1, GenericKey var2);

    public static ExecutionKeyFactory<GenericKey> unwindowed(RuntimeBuildContext buildContext) {
        return new UnwindowedFactory(buildContext);
    }

    public static ExecutionKeyFactory<Windowed<GenericKey>> windowed(RuntimeBuildContext buildContext, WindowInfo windowInfo) {
        return new WindowedFactory(windowInfo, buildContext);
    }

    public static class WindowedFactory
    implements ExecutionKeyFactory<Windowed<GenericKey>> {
        private final WindowInfo windowInfo;
        private final RuntimeBuildContext buildContext;

        public WindowedFactory(WindowInfo windowInfo, RuntimeBuildContext buildContext) {
            this.windowInfo = Objects.requireNonNull(windowInfo, "windowInfo");
            this.buildContext = Objects.requireNonNull(buildContext, "buildContext");
        }

        @Override
        public Serde<Windowed<GenericKey>> buildKeySerde(FormatInfo format, PhysicalSchema physicalSchema, QueryContext queryContext) {
            return this.buildContext.buildKeySerde(format, this.windowInfo, physicalSchema, queryContext);
        }

        @Override
        public ExecutionKeyFactory<Windowed<GenericKey>> withQueryBuilder(RuntimeBuildContext buildContext) {
            return new WindowedFactory(this.windowInfo, buildContext);
        }

        @Override
        public Windowed<GenericKey> constructNewKey(Windowed<GenericKey> oldKey, GenericKey newKey) {
            return new Windowed((Object)newKey, oldKey.window());
        }
    }

    public static class UnwindowedFactory
    implements ExecutionKeyFactory<GenericKey> {
        private final RuntimeBuildContext buildContext;

        public UnwindowedFactory(RuntimeBuildContext buildContext) {
            this.buildContext = Objects.requireNonNull(buildContext, "buildContext");
        }

        @Override
        public Serde<GenericKey> buildKeySerde(FormatInfo format, PhysicalSchema physicalSchema, QueryContext queryContext) {
            return this.buildContext.buildKeySerde(format, physicalSchema, queryContext);
        }

        @Override
        public ExecutionKeyFactory<GenericKey> withQueryBuilder(RuntimeBuildContext buildContext) {
            return new UnwindowedFactory(buildContext);
        }

        @Override
        public GenericKey constructNewKey(GenericKey oldKey, GenericKey newKey) {
            return newKey;
        }
    }
}

