/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.plan;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.plan.ExecutionStepProperties;
import io.confluent.ksql.execution.plan.ForeignKeyTableTableJoin;
import io.confluent.ksql.execution.plan.PlanBuilder;
import io.confluent.ksql.execution.plan.PlanInfo;
import io.confluent.ksql.execution.plan.PlanInfoExtractor;
import io.confluent.ksql.execution.plan.StreamAggregate;
import io.confluent.ksql.execution.plan.StreamFilter;
import io.confluent.ksql.execution.plan.StreamFlatMap;
import io.confluent.ksql.execution.plan.StreamGroupBy;
import io.confluent.ksql.execution.plan.StreamGroupByKey;
import io.confluent.ksql.execution.plan.StreamGroupByV1;
import io.confluent.ksql.execution.plan.StreamSelect;
import io.confluent.ksql.execution.plan.StreamSelectKey;
import io.confluent.ksql.execution.plan.StreamSelectKeyV1;
import io.confluent.ksql.execution.plan.StreamSink;
import io.confluent.ksql.execution.plan.StreamSource;
import io.confluent.ksql.execution.plan.StreamStreamJoin;
import io.confluent.ksql.execution.plan.StreamTableJoin;
import io.confluent.ksql.execution.plan.StreamWindowedAggregate;
import io.confluent.ksql.execution.plan.TableAggregate;
import io.confluent.ksql.execution.plan.TableFilter;
import io.confluent.ksql.execution.plan.TableGroupBy;
import io.confluent.ksql.execution.plan.TableGroupByV1;
import io.confluent.ksql.execution.plan.TableSelect;
import io.confluent.ksql.execution.plan.TableSelectKey;
import io.confluent.ksql.execution.plan.TableSink;
import io.confluent.ksql.execution.plan.TableSource;
import io.confluent.ksql.execution.plan.TableSourceV1;
import io.confluent.ksql.execution.plan.TableSuppress;
import io.confluent.ksql.execution.plan.TableTableJoin;
import io.confluent.ksql.execution.plan.WindowedStreamSource;
import io.confluent.ksql.execution.plan.WindowedTableSource;
import io.confluent.ksql.testing.EffectivelyImmutable;
import io.confluent.ksql.util.KsqlException;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
@JsonSubTypes(value={@JsonSubTypes.Type(value=StreamAggregate.class, name="streamAggregateV1"), @JsonSubTypes.Type(value=StreamFilter.class, name="streamFilterV1"), @JsonSubTypes.Type(value=StreamFlatMap.class, name="streamFlatMapV1"), @JsonSubTypes.Type(value=StreamGroupByV1.class, name="streamGroupByV1"), @JsonSubTypes.Type(value=StreamGroupBy.class, name="streamGroupByV2"), @JsonSubTypes.Type(value=StreamGroupByKey.class, name="streamGroupByKeyV1"), @JsonSubTypes.Type(value=StreamSelect.class, name="streamSelectV1"), @JsonSubTypes.Type(value=StreamSelectKeyV1.class, name="streamSelectKeyV1"), @JsonSubTypes.Type(value=StreamSelectKey.class, name="streamSelectKeyV2"), @JsonSubTypes.Type(value=StreamSink.class, name="streamSinkV1"), @JsonSubTypes.Type(value=StreamSource.class, name="streamSourceV1"), @JsonSubTypes.Type(value=WindowedStreamSource.class, name="windowedStreamSourceV1"), @JsonSubTypes.Type(value=StreamStreamJoin.class, name="streamStreamJoinV1"), @JsonSubTypes.Type(value=StreamTableJoin.class, name="streamTableJoinV1"), @JsonSubTypes.Type(value=StreamWindowedAggregate.class, name="streamWindowedAggregateV1"), @JsonSubTypes.Type(value=TableSourceV1.class, name="tableSourceV1"), @JsonSubTypes.Type(value=TableSource.class, name="tableSourceV2"), @JsonSubTypes.Type(value=WindowedTableSource.class, name="windowedTableSourceV1"), @JsonSubTypes.Type(value=TableAggregate.class, name="tableAggregateV1"), @JsonSubTypes.Type(value=TableFilter.class, name="tableFilterV1"), @JsonSubTypes.Type(value=TableGroupByV1.class, name="tableGroupByV1"), @JsonSubTypes.Type(value=TableGroupBy.class, name="tableGroupByV2"), @JsonSubTypes.Type(value=TableSelect.class, name="tableSelectV1"), @JsonSubTypes.Type(value=TableSelectKey.class, name="tableSelectKeyV1"), @JsonSubTypes.Type(value=TableSink.class, name="tableSinkV1"), @JsonSubTypes.Type(value=TableSuppress.class, name="tableSuppressV1"), @JsonSubTypes.Type(value=TableTableJoin.class, name="tableTableJoinV1"), @JsonSubTypes.Type(value=ForeignKeyTableTableJoin.class, name="fkTableTableJoinV1")})
@Immutable
public interface ExecutionStep<S> {
    public ExecutionStepProperties getProperties();

    @JsonIgnore
    public List<ExecutionStep<?>> getSources();

    default public S build(PlanBuilder planBuilder) {
        return this.build(planBuilder, this.extractPlanInfo(new PlanInfoExtractor()));
    }

    public S build(PlanBuilder var1, PlanInfo var2);

    public PlanInfo extractPlanInfo(PlanInfoExtractor var1);

    default public void validateUpgrade(@Nonnull ExecutionStep<?> to) {
        if (this.type() != StepType.PASSIVE) {
            throw new IllegalStateException("ENFORCING steps must implement validateUpgrade");
        }
        to.validateUpgrade(this.getSources().get(0));
    }

    default public StepType type() {
        throw new KsqlException("Upgrades not yet supported for " + this.getClass().getSimpleName());
    }

    default public void mustMatch(ExecutionStep<?> that, List<Property> properties) {
        for (Property property : properties) {
            Object b;
            Object a = property.apply(this);
            if (Objects.equals(a, b = property.apply(that))) continue;
            throw new KsqlException(String.format("Query is not upgradeable. Plan step of type %s must have matching %s. Values differ: %s vs. %s", this.getClass().getSimpleName(), property.name, a, b));
        }
    }

    @Immutable
    public static class Property {
        private final String name;
        @EffectivelyImmutable
        private final Function<ExecutionStep<?>, ?> getter;

        Property(String name, Function<ExecutionStep<?>, ?> getter) {
            this.name = name;
            this.getter = getter;
        }

        Object apply(ExecutionStep<?> step) {
            return this.getter.apply(step);
        }
    }

    public static enum StepType {
        ENFORCING,
        PASSIVE;

    }
}

