/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.plan;

import com.google.common.annotations.VisibleForTesting;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.plan.ExecutionStepPropertiesV1;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.execution.timestamp.TimestampColumn;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public abstract class SourceStep<K>
implements ExecutionStep<K> {
    final ExecutionStepPropertiesV1 properties;
    final String topicName;
    final Formats formats;
    final Optional<TimestampColumn> timestampColumn;
    final LogicalSchema sourceSchema;
    final int pseudoColumnVersion;

    @VisibleForTesting
    public SourceStep(ExecutionStepPropertiesV1 properties, String topicName, Formats formats, Optional<TimestampColumn> timestampColumn, LogicalSchema sourceSchema, int pseudoColumnVersion) {
        this.properties = Objects.requireNonNull(properties, "properties");
        this.topicName = Objects.requireNonNull(topicName, "topicName");
        this.formats = Objects.requireNonNull(formats, "formats");
        this.timestampColumn = Objects.requireNonNull(timestampColumn, "timestampColumn");
        this.sourceSchema = Objects.requireNonNull(sourceSchema, "sourceSchema");
        this.pseudoColumnVersion = pseudoColumnVersion;
    }

    @Override
    public ExecutionStepPropertiesV1 getProperties() {
        return this.properties;
    }

    @Override
    public List<ExecutionStep<?>> getSources() {
        return Collections.emptyList();
    }

    public LogicalSchema getSourceSchema() {
        return this.sourceSchema;
    }

    public Optional<TimestampColumn> getTimestampColumn() {
        return this.timestampColumn;
    }

    public Formats getFormats() {
        return this.formats;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public int getPseudoColumnVersion() {
        return this.pseudoColumnVersion;
    }
}

