/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.plan;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.plan.ExecutionStepPropertiesV1;
import io.confluent.ksql.execution.plan.KTableHolder;
import io.confluent.ksql.execution.plan.PlanBuilder;
import io.confluent.ksql.execution.plan.PlanInfo;
import io.confluent.ksql.execution.plan.PlanInfoExtractor;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Immutable
public class TableFilter<K>
implements ExecutionStep<KTableHolder<K>> {
    private final ExecutionStepPropertiesV1 properties;
    private final ExecutionStep<KTableHolder<K>> source;
    private final Expression filterExpression;

    public TableFilter(@JsonProperty(value="properties", required=true) ExecutionStepPropertiesV1 props, @JsonProperty(value="source", required=true) ExecutionStep<KTableHolder<K>> source, @JsonProperty(value="filterExpression", required=true) Expression filterExpression) {
        this.properties = Objects.requireNonNull(props, "props");
        this.source = Objects.requireNonNull(source, "source");
        this.filterExpression = Objects.requireNonNull(filterExpression, "filterExpression");
    }

    @Override
    public ExecutionStepPropertiesV1 getProperties() {
        return this.properties;
    }

    @Override
    @JsonIgnore
    public List<ExecutionStep<?>> getSources() {
        return Collections.singletonList(this.source);
    }

    public Expression getFilterExpression() {
        return this.filterExpression;
    }

    public ExecutionStep<KTableHolder<K>> getSource() {
        return this.source;
    }

    @Override
    public KTableHolder<K> build(PlanBuilder builder, PlanInfo info) {
        return builder.visitTableFilter(this, info);
    }

    @Override
    public PlanInfo extractPlanInfo(PlanInfoExtractor extractor) {
        return extractor.visitTableFilter(this);
    }

    @Override
    public ExecutionStep.StepType type() {
        return ExecutionStep.StepType.PASSIVE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableFilter that = (TableFilter)o;
        return Objects.equals(this.properties, that.properties) && Objects.equals(this.source, that.source) && Objects.equals((Object)this.filterExpression, (Object)that.filterExpression);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.properties, this.source, this.filterExpression});
    }
}

