/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.timestamp;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.name.ColumnName;
import java.util.Objects;
import java.util.Optional;

@Immutable
public final class TimestampColumn {
    private final ColumnName column;
    private final Optional<String> format;

    @JsonCreator
    public TimestampColumn(@JsonProperty(value="column", required=true) ColumnName column, @JsonProperty(value="format") Optional<String> format) {
        this.column = Objects.requireNonNull(column, "column");
        this.format = Objects.requireNonNull(format, "format");
    }

    public ColumnName getColumn() {
        return this.column;
    }

    public Optional<String> getFormat() {
        return this.format;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimestampColumn that = (TimestampColumn)o;
        return Objects.equals(this.column, that.column) && Objects.equals(this.format, that.format);
    }

    public int hashCode() {
        return Objects.hash(this.column, this.format);
    }

    public String toString() {
        return "TimestampColumn{column=" + this.column + ", format=" + this.format + '}';
    }
}

