/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.windows;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.windows.KsqlWindowExpression;
import io.confluent.ksql.execution.windows.WindowTimeClause;
import io.confluent.ksql.execution.windows.WindowVisitor;
import io.confluent.ksql.model.WindowType;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.OutputRefinement;
import io.confluent.ksql.serde.WindowInfo;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class SessionWindowExpression
extends KsqlWindowExpression {
    private final WindowTimeClause gap;

    @JsonCreator
    public static SessionWindowExpression of(@JsonProperty(value="gap", required=true) WindowTimeClause gap, @JsonProperty(value="retention") WindowTimeClause retention, @JsonProperty(value="gracePeriod") WindowTimeClause gracePeriod, @JsonProperty(value="emitStrategy") OutputRefinement emitStrategy) {
        return new SessionWindowExpression(Optional.empty(), gap, Optional.ofNullable(retention), Optional.ofNullable(gracePeriod), Optional.ofNullable(emitStrategy));
    }

    public SessionWindowExpression(WindowTimeClause gap) {
        this(Optional.empty(), gap, Optional.empty(), Optional.empty());
    }

    public SessionWindowExpression(Optional<NodeLocation> location, WindowTimeClause gap, Optional<WindowTimeClause> retention, Optional<WindowTimeClause> gracePeriod) {
        this(location, gap, retention, gracePeriod, Optional.empty());
    }

    public SessionWindowExpression(Optional<NodeLocation> location, WindowTimeClause gap, Optional<WindowTimeClause> retention, Optional<WindowTimeClause> gracePeriod, Optional<OutputRefinement> emitStrategy) {
        super(location, retention, gracePeriod, emitStrategy);
        this.gap = Objects.requireNonNull(gap, "gap");
    }

    public WindowTimeClause getGap() {
        return this.gap;
    }

    @Override
    @JsonIgnore
    public WindowInfo getWindowInfo() {
        return WindowInfo.of((WindowType)WindowType.SESSION, Optional.empty(), (Optional)this.emitStrategy);
    }

    public WindowType getWindowType() {
        return WindowType.SESSION;
    }

    @Override
    public <R, C> R accept(WindowVisitor<R, C> visitor, C context) {
        return visitor.visitSessionWindowExpression(this, context);
    }

    public String toString() {
        return " SESSION ( " + this.gap + this.retention.map(w -> " , RETENTION " + w).orElse("") + this.gracePeriod.map(g -> " , GRACE PERIOD " + g).orElse("") + " ) ";
    }

    public int hashCode() {
        return Objects.hash(this.gap, this.retention, this.gracePeriod);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SessionWindowExpression sessionWindowExpression = (SessionWindowExpression)((Object)o);
        return Objects.equals(this.gap, sessionWindowExpression.gap) && Objects.equals(this.gracePeriod, sessionWindowExpression.gracePeriod) && Objects.equals(this.retention, sessionWindowExpression.retention);
    }
}

