/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.windows;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.windows.KsqlWindowExpression;
import io.confluent.ksql.execution.windows.WindowTimeClause;
import io.confluent.ksql.execution.windows.WindowVisitor;
import io.confluent.ksql.model.WindowType;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.OutputRefinement;
import io.confluent.ksql.serde.WindowInfo;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class TumblingWindowExpression
extends KsqlWindowExpression {
    private final WindowTimeClause size;

    @JsonCreator
    public static TumblingWindowExpression of(@JsonProperty(value="size", required=true) WindowTimeClause size, @JsonProperty(value="retention") WindowTimeClause retention, @JsonProperty(value="gracePeriod") WindowTimeClause gracePeriod, @JsonProperty(value="emitStrategy") OutputRefinement emitStrategy) {
        return new TumblingWindowExpression(Optional.empty(), size, Optional.ofNullable(retention), Optional.ofNullable(gracePeriod), Optional.ofNullable(emitStrategy));
    }

    public TumblingWindowExpression(WindowTimeClause size) {
        this(Optional.empty(), size, Optional.empty(), Optional.empty());
    }

    public TumblingWindowExpression(Optional<NodeLocation> location, WindowTimeClause size, Optional<WindowTimeClause> retention, Optional<WindowTimeClause> gracePeriod) {
        this(location, size, retention, gracePeriod, Optional.empty());
    }

    public TumblingWindowExpression(Optional<NodeLocation> location, WindowTimeClause size, Optional<WindowTimeClause> retention, Optional<WindowTimeClause> gracePeriod, Optional<OutputRefinement> emitStrategy) {
        super(location, retention, gracePeriod, emitStrategy);
        this.size = Objects.requireNonNull(size, "size");
    }

    @Override
    @JsonIgnore
    public WindowInfo getWindowInfo() {
        return WindowInfo.of((WindowType)WindowType.TUMBLING, Optional.of(this.size.toDuration()), (Optional)this.emitStrategy);
    }

    public WindowType getWindowType() {
        return WindowType.TUMBLING;
    }

    public WindowTimeClause getSize() {
        return this.size;
    }

    @Override
    public <R, C> R accept(WindowVisitor<R, C> visitor, C context) {
        return visitor.visitTumblingWindowExpression(this, context);
    }

    public String toString() {
        return " TUMBLING ( SIZE " + this.size + this.retention.map(w -> " , RETENTION " + w).orElse("") + this.gracePeriod.map(g -> " , GRACE PERIOD " + g).orElse("") + " ) ";
    }

    public int hashCode() {
        return Objects.hash(this.size, this.retention, this.gracePeriod);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        TumblingWindowExpression tumblingWindowExpression = (TumblingWindowExpression)((Object)o);
        return Objects.equals(this.size, tumblingWindowExpression.size) && Objects.equals(this.gracePeriod, tumblingWindowExpression.gracePeriod) && Objects.equals(this.retention, tumblingWindowExpression.retention);
    }
}

