/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.services;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.TopicPartition;

public interface KafkaTopicClient {
    default public void validateCreateTopic(String topic, int numPartitions, short replicationFactor) {
        this.validateCreateTopic(topic, numPartitions, replicationFactor, Collections.emptyMap());
    }

    default public void validateCreateTopic(String topic, int numPartitions, short replicationFactor, Map<String, ?> configs) {
        this.createTopic(topic, numPartitions, replicationFactor, configs, new CreateTopicsOptions().validateOnly(true));
    }

    default public void createTopic(String topic, int numPartitions, short replicationFactor) {
        this.createTopic(topic, numPartitions, replicationFactor, Collections.emptyMap());
    }

    default public void createTopic(String topic, int numPartitions, short replicationFactor, Map<String, ?> configs) {
        this.createTopic(topic, numPartitions, replicationFactor, configs, new CreateTopicsOptions());
    }

    public void createTopic(String var1, int var2, short var3, Map<String, ?> var4, CreateTopicsOptions var5);

    public boolean isTopicExists(String var1);

    public Set<String> listTopicNames();

    default public Map<String, TopicDescription> describeTopics(Collection<String> topicNames) {
        return this.describeTopics(topicNames, false);
    }

    public Map<String, TopicDescription> describeTopics(Collection<String> var1, Boolean var2);

    default public TopicDescription describeTopic(String topicName) {
        return this.describeTopics((Collection<String>)ImmutableList.of((Object)topicName)).get(topicName);
    }

    default public TopicDescription describeTopic(String topicName, Boolean skipRetriesOnFailure) {
        return this.describeTopics((Collection<String>)ImmutableList.of((Object)topicName), skipRetriesOnFailure).get(topicName);
    }

    public Map<String, String> getTopicConfig(String var1);

    public boolean addTopicConfig(String var1, Map<String, ?> var2);

    public TopicCleanupPolicy getTopicCleanupPolicy(String var1);

    public void deleteTopics(Collection<String> var1);

    public void deleteInternalTopics(String var1);

    public Map<TopicPartition, Long> listTopicsOffsets(Collection<String> var1, OffsetSpec var2);

    default public Map<TopicPartition, Long> listTopicsStartOffsets(Collection<String> topicNames) {
        return this.listTopicsOffsets(topicNames, OffsetSpec.earliest());
    }

    default public Map<TopicPartition, Long> listTopicsEndOffsets(Collection<String> topicName) {
        return this.listTopicsOffsets(topicName, OffsetSpec.latest());
    }

    public static Optional<Long> getRetentionMs(Map<String, ?> config) {
        if (config.containsKey("retention.ms")) {
            return Optional.ofNullable(Long.parseLong(String.valueOf(config.get("retention.ms"))));
        }
        return Optional.empty();
    }

    public static enum TopicCleanupPolicy {
        COMPACT,
        DELETE,
        COMPACT_DELETE;

    }
}

