/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.auth;

import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.KafkaRestContext;
import io.confluent.kafkarest.auth.KafkaRestContextFactory;
import io.confluent.kafkarest.auth.RestRequestProxyProtocolInfo;
import java.security.Principal;
import java.util.Objects;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;

public final class CloudExtensionsContextFilter
implements ContainerRequestFilter {
    private final KafkaRestConfig config;
    @Context
    private HttpServletRequest httpRequest;

    @Inject
    public CloudExtensionsContextFilter(KafkaRestConfig config) {
        this.config = Objects.requireNonNull(config);
    }

    public void filter(ContainerRequestContext requestContext) {
        Principal principal = requestContext.getSecurityContext().getUserPrincipal();
        RestRequestProxyProtocolInfo proxyProtocolInfo = new RestRequestProxyProtocolInfo(this.httpRequest.getRemoteAddr(), this.httpRequest.getRemotePort());
        KafkaRestContext context = KafkaRestContextFactory.create(principal, this.config, proxyProtocolInfo);
        requestContext.setProperty("io.confluent.kafkarest.backends.kafka.CloudKafkaModule.KafkaRestContext", (Object)context);
    }
}

