/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.auth;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.confluent.kafkarest.CeKafkaRestConfig;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.backends.kafka.KafkaProducerCache;
import io.confluent.kafkarest.utils.ReferenceCountingHolder;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaProducerCacheImpl
implements KafkaProducerCache {
    private static final Logger log = LoggerFactory.getLogger(KafkaProducerCacheImpl.class);
    public static final String PRODUCER_CACHE_CAPACITY_CONFIG = "kafka.producer.cache.capacity";
    public static final String PRODUCER_CACHE_VALIDITY_MILLIS_CONFIG = "kafka.producer.cache.validity.ms";
    public static final int PRODUCER_CACHE_DEFAULT_CAPACITY = 100;
    public static final long PRODUCER_CACHE_DEFAULT_VALIDITY_MILLIS = 30000L;
    private final int capacity;
    private final long validity;
    private final Cache<String, ReferenceCountingHolder<Producer<byte[], byte[]>>> cache;

    @Inject
    public KafkaProducerCacheImpl(Provider<KafkaRestConfig> configProvider) {
        KafkaRestConfig config = (KafkaRestConfig)configProvider.get();
        this.capacity = CeKafkaRestConfig.getIntOrDefault(config, PRODUCER_CACHE_CAPACITY_CONFIG, 100);
        this.validity = CeKafkaRestConfig.getLongOrDefault(config, PRODUCER_CACHE_VALIDITY_MILLIS_CONFIG, 30000L);
        log.info("KRest cache: capacity {}, validity {}ms", (Object)this.capacity, (Object)this.validity);
        this.cache = CacheBuilder.newBuilder().maximumSize((long)this.capacity).expireAfterAccess(this.validity, TimeUnit.MILLISECONDS).removalListener(notification -> {
            log.info("KRest cache: Producer evicted from cache");
            ((ReferenceCountingHolder)notification.getValue()).decrement();
        }).build();
    }

    @Override
    public Producer<byte[], byte[]> provide(String cacheKey, Map<String, Object> configs) {
        if (cacheKey == null) {
            return new KafkaProducer(configs, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
        }
        try {
            ReferenceCountingHolder holder = (ReferenceCountingHolder)this.cache.get((Object)cacheKey, this.getProducerCallable(configs));
            holder.increment();
            log.debug("KRest cache: Serving produce request");
            InvocationHandler delegatingHandler = (proxy, method, args) -> {
                if ("close".equals(method.getName())) {
                    holder.decrement();
                    return null;
                }
                Object returnObject = null;
                try {
                    returnObject = method.invoke(holder.get(), args);
                }
                catch (InvocationTargetException e) {
                    log.error("KRest cache: error in producer invocation: " + e.getCause());
                    throw e.getCause();
                }
                return returnObject;
            };
            return (Producer)Proxy.newProxyInstance(Producer.class.getClassLoader(), new Class[]{Producer.class}, delegatingHandler);
        }
        catch (UncheckedExecutionException uee) {
            Throwables.throwIfUnchecked((Throwable)uee.getCause());
            throw new RuntimeException(uee);
        }
        catch (ExecutionException ee) {
            throw new RuntimeException(ee.getCause());
        }
    }

    @Override
    public void dispose(Producer<byte[], byte[]> producer) {
        log.debug("KRest cache: closing producer");
        producer.close();
    }

    private Callable<ReferenceCountingHolder<Producer<byte[], byte[]>>> getProducerCallable(Map<String, Object> configs) {
        return () -> {
            KafkaProducer producer = new KafkaProducer(configs, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
            log.debug("KRest cache: creating new producer for cache");
            return new ReferenceCountingHolder<KafkaProducer>(producer);
        };
    }

    @VisibleForTesting
    Cache<String, ReferenceCountingHolder<Producer<byte[], byte[]>>> getCache() {
        return this.cache;
    }

    @VisibleForTesting
    int getCapacity() {
        return this.capacity;
    }

    @VisibleForTesting
    long getValidity() {
        return this.validity;
    }
}

