/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import io.confluent.kafkarest.entities.AlterMirrors;
import io.confluent.kafkarest.entities.Mirror;
import io.confluent.kafkarest.entities.MirrorStatus;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public interface MirrorManager {
    public CompletableFuture<List<Mirror>> listMirrors(String var1, MirrorStatus var2);

    default public CompletableFuture<List<Mirror>> listMirrors(String clusterId, String linkName, MirrorStatus mirrorStatus) {
        return this.listMirrors(clusterId, mirrorStatus).thenApply(mirrors -> mirrors.stream().filter(mirror -> mirror.getLinkName().equals(linkName)).collect(Collectors.toList()));
    }

    public CompletableFuture<Optional<Mirror>> getMirror(String var1, String var2, String var3);

    public CompletableFuture<Void> createMirror(String var1, String var2, String var3, String var4, Map<String, Optional<String>> var5, Optional<Short> var6);

    public CompletableFuture<List<AlterMirrors>> pauseMirrors(String var1, String var2, Set<String> var3, String var4, boolean var5);

    public CompletableFuture<List<AlterMirrors>> resumeMirrors(String var1, String var2, Set<String> var3, String var4, boolean var5);

    public CompletableFuture<List<AlterMirrors>> promoteMirrors(String var1, String var2, Set<String> var3, String var4, boolean var5);

    public CompletableFuture<List<AlterMirrors>> failOverMirrors(String var1, String var2, Set<String> var3, String var4, boolean var5);
}

