/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.AutoValue_Link;
import java.util.UUID;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.common.ClusterLinkError;
import org.apache.kafka.common.Uuid;

@AutoValue
public abstract class Link {
    Link() {
    }

    public abstract String getRemoteClusterId();

    public abstract String getLinkName();

    public abstract UUID getLinkId();

    public abstract Uuid getClusterLinkId();

    public abstract ClusterLinkDescription.LinkMode getLinkMode();

    public abstract ImmutableList<String> getTopics();

    public abstract ClusterLinkError getLinkError();

    public abstract String getLinkErrorMessage();

    public abstract ClusterLinkDescription.LinkState getLinkState();

    public static Link create(String remoteClusterId, String linkName, Uuid clusterLinkId, ClusterLinkDescription.LinkMode linkMode, ImmutableList<String> topics, ClusterLinkError linkError, String linkErrorMessage, ClusterLinkDescription.LinkState linkState) {
        return new AutoValue_Link(linkName, remoteClusterId, new UUID(clusterLinkId.getMostSignificantBits(), clusterLinkId.getLeastSignificantBits()), clusterLinkId, linkMode, topics, linkError, linkErrorMessage, linkState);
    }
}

