/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.ConfigSource;
import io.confluent.kafkarest.entities.v3.ConfigSynonymData;
import io.confluent.kafkarest.entities.v3.LinkConfigData;
import io.confluent.kafkarest.entities.v3.Resource;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

final class AutoValue_LinkConfigData
extends LinkConfigData {
    private final String kind;
    private final Resource.Metadata metadata;
    private final String clusterId;
    private final String name;
    private final Optional<String> value;
    private final boolean default0;
    private final boolean readOnly;
    private final boolean sensitive;
    private final ConfigSource source;
    private final ImmutableList<ConfigSynonymData> synonyms;
    private final String linkName;

    private AutoValue_LinkConfigData(String kind, Resource.Metadata metadata, String clusterId, String name, Optional<String> value, boolean default0, boolean readOnly, boolean sensitive, ConfigSource source, ImmutableList<ConfigSynonymData> synonyms, String linkName) {
        this.kind = kind;
        this.metadata = metadata;
        this.clusterId = clusterId;
        this.name = name;
        this.value = value;
        this.default0 = default0;
        this.readOnly = readOnly;
        this.sensitive = sensitive;
        this.source = source;
        this.synonyms = synonyms;
        this.linkName = linkName;
    }

    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="metadata")
    public Resource.Metadata getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="cluster_id")
    public String getClusterId() {
        return this.clusterId;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="value")
    public Optional<String> getValue() {
        return this.value;
    }

    @JsonProperty(value="is_default")
    public boolean isDefault() {
        return this.default0;
    }

    @JsonProperty(value="is_read_only")
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @JsonProperty(value="is_sensitive")
    public boolean isSensitive() {
        return this.sensitive;
    }

    @JsonProperty(value="source")
    public ConfigSource getSource() {
        return this.source;
    }

    @JsonProperty(value="synonyms")
    public ImmutableList<ConfigSynonymData> getSynonyms() {
        return this.synonyms;
    }

    @Override
    @JsonProperty(value="link_name")
    public String getLinkName() {
        return this.linkName;
    }

    public String toString() {
        return "LinkConfigData{kind=" + this.kind + ", metadata=" + this.metadata + ", clusterId=" + this.clusterId + ", name=" + this.name + ", value=" + this.value + ", default=" + this.default0 + ", readOnly=" + this.readOnly + ", sensitive=" + this.sensitive + ", source=" + this.source + ", synonyms=" + this.synonyms + ", linkName=" + this.linkName + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LinkConfigData) {
            LinkConfigData that = (LinkConfigData)((Object)o);
            return this.kind.equals(that.getKind()) && this.metadata.equals(that.getMetadata()) && this.clusterId.equals(that.getClusterId()) && this.name.equals(that.getName()) && this.value.equals(that.getValue()) && this.default0 == that.isDefault() && this.readOnly == that.isReadOnly() && this.sensitive == that.isSensitive() && this.source.equals((Object)that.getSource()) && this.synonyms.equals((Object)that.getSynonyms()) && this.linkName.equals(that.getLinkName());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.kind.hashCode();
        h$ *= 1000003;
        h$ ^= this.metadata.hashCode();
        h$ *= 1000003;
        h$ ^= this.clusterId.hashCode();
        h$ *= 1000003;
        h$ ^= this.name.hashCode();
        h$ *= 1000003;
        h$ ^= this.value.hashCode();
        h$ *= 1000003;
        h$ ^= this.default0 ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.readOnly ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.sensitive ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.source.hashCode();
        h$ *= 1000003;
        h$ ^= this.synonyms.hashCode();
        h$ *= 1000003;
        return h$ ^= this.linkName.hashCode();
    }

    static final class Builder
    extends LinkConfigData.Builder {
        private String kind;
        private Resource.Metadata metadata;
        private String clusterId;
        private String name;
        private Optional<String> value = Optional.empty();
        private Boolean default0;
        private Boolean readOnly;
        private Boolean sensitive;
        private ConfigSource source;
        private ImmutableList<ConfigSynonymData> synonyms;
        private String linkName;

        Builder() {
        }

        public LinkConfigData.Builder setKind(String kind) {
            if (kind == null) {
                throw new NullPointerException("Null kind");
            }
            this.kind = kind;
            return this;
        }

        public LinkConfigData.Builder setMetadata(Resource.Metadata metadata) {
            if (metadata == null) {
                throw new NullPointerException("Null metadata");
            }
            this.metadata = metadata;
            return this;
        }

        public LinkConfigData.Builder setClusterId(String clusterId) {
            if (clusterId == null) {
                throw new NullPointerException("Null clusterId");
            }
            this.clusterId = clusterId;
            return this;
        }

        public LinkConfigData.Builder setName(String name) {
            if (name == null) {
                throw new NullPointerException("Null name");
            }
            this.name = name;
            return this;
        }

        public LinkConfigData.Builder setValue(@Nullable String value) {
            this.value = Optional.ofNullable(value);
            return this;
        }

        public LinkConfigData.Builder setDefault(boolean default0) {
            this.default0 = default0;
            return this;
        }

        public LinkConfigData.Builder setReadOnly(boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public LinkConfigData.Builder setSensitive(boolean sensitive) {
            this.sensitive = sensitive;
            return this;
        }

        public LinkConfigData.Builder setSource(ConfigSource source) {
            if (source == null) {
                throw new NullPointerException("Null source");
            }
            this.source = source;
            return this;
        }

        public LinkConfigData.Builder setSynonyms(List<ConfigSynonymData> synonyms) {
            this.synonyms = ImmutableList.copyOf(synonyms);
            return this;
        }

        @Override
        public LinkConfigData.Builder setLinkName(String linkName) {
            if (linkName == null) {
                throw new NullPointerException("Null linkName");
            }
            this.linkName = linkName;
            return this;
        }

        @Override
        public LinkConfigData build() {
            String missing = "";
            if (this.kind == null) {
                missing = missing + " kind";
            }
            if (this.metadata == null) {
                missing = missing + " metadata";
            }
            if (this.clusterId == null) {
                missing = missing + " clusterId";
            }
            if (this.name == null) {
                missing = missing + " name";
            }
            if (this.default0 == null) {
                missing = missing + " default";
            }
            if (this.readOnly == null) {
                missing = missing + " readOnly";
            }
            if (this.sensitive == null) {
                missing = missing + " sensitive";
            }
            if (this.source == null) {
                missing = missing + " source";
            }
            if (this.synonyms == null) {
                missing = missing + " synonyms";
            }
            if (this.linkName == null) {
                missing = missing + " linkName";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_LinkConfigData(this.kind, this.metadata, this.clusterId, this.name, this.value, this.default0, this.readOnly, this.sensitive, this.source, this.synonyms, this.linkName);
        }
    }
}

