/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.v3.LinkData;
import io.confluent.kafkarest.entities.v3.Resource;
import java.util.UUID;
import javax.annotation.Nullable;

final class AutoValue_LinkData
extends LinkData {
    private final String kind;
    private final Resource.Metadata metadata;
    private final String sourceClusterId;
    private final String destinationClusterId;
    private final String remoteClusterId;
    private final String linkName;
    private final UUID linkId;
    private final String clusterLinkId;
    private final ImmutableList<String> topics;
    private final String linkError;
    private final String linkErrorMessage;
    private final String linkState;

    private AutoValue_LinkData(String kind, Resource.Metadata metadata, @Nullable String sourceClusterId, @Nullable String destinationClusterId, @Nullable String remoteClusterId, String linkName, UUID linkId, String clusterLinkId, ImmutableList<String> topics, String linkError, String linkErrorMessage, String linkState) {
        this.kind = kind;
        this.metadata = metadata;
        this.sourceClusterId = sourceClusterId;
        this.destinationClusterId = destinationClusterId;
        this.remoteClusterId = remoteClusterId;
        this.linkName = linkName;
        this.linkId = linkId;
        this.clusterLinkId = clusterLinkId;
        this.topics = topics;
        this.linkError = linkError;
        this.linkErrorMessage = linkErrorMessage;
        this.linkState = linkState;
    }

    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="metadata")
    public Resource.Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="source_cluster_id")
    @Nullable
    public String getSourceClusterId() {
        return this.sourceClusterId;
    }

    @Override
    @JsonProperty(value="destination_cluster_id")
    @Nullable
    public String getDestinationClusterId() {
        return this.destinationClusterId;
    }

    @Override
    @JsonProperty(value="remote_cluster_id")
    @Nullable
    public String getRemoteClusterId() {
        return this.remoteClusterId;
    }

    @Override
    @JsonProperty(value="link_name")
    public String getLinkName() {
        return this.linkName;
    }

    @Override
    @JsonProperty(value="link_id")
    public UUID getLinkId() {
        return this.linkId;
    }

    @Override
    @JsonProperty(value="cluster_link_id")
    public String getClusterLinkId() {
        return this.clusterLinkId;
    }

    @Override
    @JsonProperty(value="topic_names")
    public ImmutableList<String> getTopics() {
        return this.topics;
    }

    @Override
    @JsonProperty(value="link_error")
    public String getLinkError() {
        return this.linkError;
    }

    @Override
    @JsonProperty(value="link_error_message")
    public String getLinkErrorMessage() {
        return this.linkErrorMessage;
    }

    @Override
    @JsonProperty(value="link_state")
    public String getLinkState() {
        return this.linkState;
    }

    public String toString() {
        return "LinkData{kind=" + this.kind + ", metadata=" + this.metadata + ", sourceClusterId=" + this.sourceClusterId + ", destinationClusterId=" + this.destinationClusterId + ", remoteClusterId=" + this.remoteClusterId + ", linkName=" + this.linkName + ", linkId=" + this.linkId + ", clusterLinkId=" + this.clusterLinkId + ", topics=" + this.topics + ", linkError=" + this.linkError + ", linkErrorMessage=" + this.linkErrorMessage + ", linkState=" + this.linkState + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LinkData) {
            LinkData that = (LinkData)((Object)o);
            return this.kind.equals(that.getKind()) && this.metadata.equals(that.getMetadata()) && (this.sourceClusterId == null ? that.getSourceClusterId() == null : this.sourceClusterId.equals(that.getSourceClusterId())) && (this.destinationClusterId == null ? that.getDestinationClusterId() == null : this.destinationClusterId.equals(that.getDestinationClusterId())) && (this.remoteClusterId == null ? that.getRemoteClusterId() == null : this.remoteClusterId.equals(that.getRemoteClusterId())) && this.linkName.equals(that.getLinkName()) && this.linkId.equals(that.getLinkId()) && this.clusterLinkId.equals(that.getClusterLinkId()) && this.topics.equals(that.getTopics()) && this.linkError.equals(that.getLinkError()) && this.linkErrorMessage.equals(that.getLinkErrorMessage()) && this.linkState.equals(that.getLinkState());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.kind.hashCode();
        h$ *= 1000003;
        h$ ^= this.metadata.hashCode();
        h$ *= 1000003;
        h$ ^= this.sourceClusterId == null ? 0 : this.sourceClusterId.hashCode();
        h$ *= 1000003;
        h$ ^= this.destinationClusterId == null ? 0 : this.destinationClusterId.hashCode();
        h$ *= 1000003;
        h$ ^= this.remoteClusterId == null ? 0 : this.remoteClusterId.hashCode();
        h$ *= 1000003;
        h$ ^= this.linkName.hashCode();
        h$ *= 1000003;
        h$ ^= this.linkId.hashCode();
        h$ *= 1000003;
        h$ ^= this.clusterLinkId.hashCode();
        h$ *= 1000003;
        h$ ^= this.topics.hashCode();
        h$ *= 1000003;
        h$ ^= this.linkError.hashCode();
        h$ *= 1000003;
        h$ ^= this.linkErrorMessage.hashCode();
        h$ *= 1000003;
        return h$ ^= this.linkState.hashCode();
    }

    static final class Builder
    extends LinkData.Builder {
        private String kind;
        private Resource.Metadata metadata;
        private String sourceClusterId;
        private String destinationClusterId;
        private String remoteClusterId;
        private String linkName;
        private UUID linkId;
        private String clusterLinkId;
        private ImmutableList<String> topics;
        private String linkError;
        private String linkErrorMessage;
        private String linkState;

        Builder() {
        }

        public LinkData.Builder setKind(String kind) {
            if (kind == null) {
                throw new NullPointerException("Null kind");
            }
            this.kind = kind;
            return this;
        }

        public LinkData.Builder setMetadata(Resource.Metadata metadata) {
            if (metadata == null) {
                throw new NullPointerException("Null metadata");
            }
            this.metadata = metadata;
            return this;
        }

        @Override
        public LinkData.Builder setSourceClusterId(String sourceClusterId) {
            this.sourceClusterId = sourceClusterId;
            return this;
        }

        @Override
        public LinkData.Builder setDestinationClusterId(String destinationClusterId) {
            this.destinationClusterId = destinationClusterId;
            return this;
        }

        @Override
        public LinkData.Builder setRemoteClusterId(String remoteClusterId) {
            this.remoteClusterId = remoteClusterId;
            return this;
        }

        @Override
        public LinkData.Builder setLinkName(String linkName) {
            if (linkName == null) {
                throw new NullPointerException("Null linkName");
            }
            this.linkName = linkName;
            return this;
        }

        @Override
        public LinkData.Builder setLinkId(UUID linkId) {
            if (linkId == null) {
                throw new NullPointerException("Null linkId");
            }
            this.linkId = linkId;
            return this;
        }

        @Override
        public LinkData.Builder setClusterLinkId(String clusterLinkId) {
            if (clusterLinkId == null) {
                throw new NullPointerException("Null clusterLinkId");
            }
            this.clusterLinkId = clusterLinkId;
            return this;
        }

        @Override
        public LinkData.Builder setTopics(ImmutableList<String> topics) {
            if (topics == null) {
                throw new NullPointerException("Null topics");
            }
            this.topics = topics;
            return this;
        }

        @Override
        public LinkData.Builder setLinkError(String linkError) {
            if (linkError == null) {
                throw new NullPointerException("Null linkError");
            }
            this.linkError = linkError;
            return this;
        }

        @Override
        public LinkData.Builder setLinkErrorMessage(String linkErrorMessage) {
            if (linkErrorMessage == null) {
                throw new NullPointerException("Null linkErrorMessage");
            }
            this.linkErrorMessage = linkErrorMessage;
            return this;
        }

        @Override
        public LinkData.Builder setLinkState(String linkState) {
            if (linkState == null) {
                throw new NullPointerException("Null linkState");
            }
            this.linkState = linkState;
            return this;
        }

        @Override
        public LinkData build() {
            String missing = "";
            if (this.kind == null) {
                missing = missing + " kind";
            }
            if (this.metadata == null) {
                missing = missing + " metadata";
            }
            if (this.linkName == null) {
                missing = missing + " linkName";
            }
            if (this.linkId == null) {
                missing = missing + " linkId";
            }
            if (this.clusterLinkId == null) {
                missing = missing + " clusterLinkId";
            }
            if (this.topics == null) {
                missing = missing + " topics";
            }
            if (this.linkError == null) {
                missing = missing + " linkError";
            }
            if (this.linkErrorMessage == null) {
                missing = missing + " linkErrorMessage";
            }
            if (this.linkState == null) {
                missing = missing + " linkState";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_LinkData(this.kind, this.metadata, this.sourceClusterId, this.destinationClusterId, this.remoteClusterId, this.linkName, this.linkId, this.clusterLinkId, this.topics, this.linkError, this.linkErrorMessage, this.linkState);
        }
    }
}

