/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.v3.MirrorData;
import io.confluent.kafkarest.entities.v3.MirrorDataList;
import io.confluent.kafkarest.entities.v3.ResourceCollection;
import java.util.List;

final class AutoValue_MirrorDataList
extends MirrorDataList {
    private final String kind;
    private final ResourceCollection.Metadata metadata;
    private final ImmutableList<MirrorData> data;

    private AutoValue_MirrorDataList(String kind, ResourceCollection.Metadata metadata, ImmutableList<MirrorData> data) {
        this.kind = kind;
        this.metadata = metadata;
        this.data = data;
    }

    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="metadata")
    public ResourceCollection.Metadata getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="data")
    public ImmutableList<MirrorData> getData() {
        return this.data;
    }

    public String toString() {
        return "MirrorDataList{kind=" + this.kind + ", metadata=" + this.metadata + ", data=" + this.data + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MirrorDataList) {
            MirrorDataList that = (MirrorDataList)((Object)o);
            return this.kind.equals(that.getKind()) && this.metadata.equals(that.getMetadata()) && this.data.equals((Object)that.getData());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.kind.hashCode();
        h$ *= 1000003;
        h$ ^= this.metadata.hashCode();
        h$ *= 1000003;
        return h$ ^= this.data.hashCode();
    }

    static final class Builder
    extends MirrorDataList.Builder {
        private String kind;
        private ResourceCollection.Metadata metadata;
        private ImmutableList<MirrorData> data;

        Builder() {
        }

        public MirrorDataList.Builder setKind(String kind) {
            if (kind == null) {
                throw new NullPointerException("Null kind");
            }
            this.kind = kind;
            return this;
        }

        public MirrorDataList.Builder setMetadata(ResourceCollection.Metadata metadata) {
            if (metadata == null) {
                throw new NullPointerException("Null metadata");
            }
            this.metadata = metadata;
            return this;
        }

        public MirrorDataList.Builder setData(List<MirrorData> data) {
            this.data = ImmutableList.copyOf(data);
            return this;
        }

        public MirrorDataList build() {
            String missing = "";
            if (this.kind == null) {
                missing = missing + " kind";
            }
            if (this.metadata == null) {
                missing = missing + " metadata";
            }
            if (this.data == null) {
                missing = missing + " data";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_MirrorDataList(this.kind, this.metadata, this.data);
        }
    }
}

