/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import io.confluent.kafkarest.entities.BrokerSubTaskStatuses;
import io.confluent.kafkarest.entities.v3.AutoValue_BrokerSubTaskStatusesData;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.kafka.clients.admin.BrokerReplicaExclusionStatus;
import org.apache.kafka.clients.admin.BrokerShutdownStatus;
import org.apache.kafka.clients.admin.PartitionReassignmentsStatus;

@AutoValue
public abstract class BrokerSubTaskStatusesData {
    BrokerSubTaskStatusesData() {
    }

    @JsonProperty(value="broker_replica_exclusion_status")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public abstract Optional<BrokerReplicaExclusionStatus> getBrokerReplicaExclusionStatus();

    @JsonProperty(value="partition_reassignment_status")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public abstract Optional<PartitionReassignmentsStatus> getPartitionReassignmentStatus();

    @JsonProperty(value="broker_shutdown_status")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public abstract Optional<BrokerShutdownStatus> getBrokerShutdownStatus();

    public static Builder builder() {
        return new AutoValue_BrokerSubTaskStatusesData.Builder();
    }

    public static BrokerSubTaskStatusesData fromBrokerSubTaskStatuses(BrokerSubTaskStatuses brokerSubTaskStatuses) {
        return BrokerSubTaskStatusesData.builder().setBrokerReplicaExclusionStatus(brokerSubTaskStatuses.getBrokerReplicaExclusionStatus().orElse(null)).setPartitionReassignmentStatus(brokerSubTaskStatuses.getPartitionReassignmentStatus().orElse(null)).setBrokerShutdownStatus(brokerSubTaskStatuses.getBrokerShutdownStatus().orElse(null)).build();
    }

    @JsonCreator
    static BrokerSubTaskStatusesData fromJson(@JsonProperty(value="broker_replica_exclusion_status") BrokerReplicaExclusionStatus brokerReplicaExclusionStatus, @JsonProperty(value="partition_reassignment_status") PartitionReassignmentsStatus partitionReassignmentStatus, @JsonProperty(value="broker_shutdown_status") BrokerShutdownStatus brokerShutdownStatus) {
        return BrokerSubTaskStatusesData.builder().setBrokerReplicaExclusionStatus(brokerReplicaExclusionStatus).setPartitionReassignmentStatus(partitionReassignmentStatus).setBrokerShutdownStatus(brokerShutdownStatus).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        Builder() {
        }

        public abstract Builder setBrokerReplicaExclusionStatus(@Nullable BrokerReplicaExclusionStatus var1);

        public abstract Builder setPartitionReassignmentStatus(@Nullable PartitionReassignmentsStatus var1);

        public abstract Builder setBrokerShutdownStatus(@Nullable BrokerShutdownStatus var1);

        public abstract BrokerSubTaskStatusesData build();
    }
}

