/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources;

import io.confluent.kafkarest.controllers.HealthCheckManager;
import io.confluent.kafkarest.entities.HealthCheckStatusResponse;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;

@Path(value="/health")
@Produces(value={"application/json"})
@ResourceAccesslistFeature.ResourceName(value="api.health.*")
public final class HealthCheckAction {
    private final Provider<HealthCheckManager> healthCheckManager;

    @Inject
    public HealthCheckAction(Provider<HealthCheckManager> healthCheckManager) {
        this.healthCheckManager = Objects.requireNonNull(healthCheckManager);
    }

    @GET
    @ResourceAccesslistFeature.ResourceName(value="api.health.get")
    public void getServiceHealth(@Suspended AsyncResponse asyncResponse) {
        CompletionStage response = ((HealthCheckManager)this.healthCheckManager.get()).getHealthCheckStatus().thenApply(HealthCheckStatusResponse::create);
        AsyncResponses.asyncResume((AsyncResponse)asyncResponse, (CompletableFuture)response);
    }
}

