/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.BrokerTaskManager;
import io.confluent.kafkarest.entities.BrokerTask;
import io.confluent.kafkarest.entities.BrokerTaskType;
import io.confluent.kafkarest.entities.v3.BrokerTaskDataList;
import io.confluent.kafkarest.entities.v3.GetBrokerTaskResponse;
import io.confluent.kafkarest.entities.v3.ListBrokerTasksByBrokerResponse;
import io.confluent.kafkarest.entities.v3.ResourceCollection;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.resources.v3.BrokerTaskResource;
import io.confluent.kafkarest.response.CrnFactory;
import io.confluent.kafkarest.response.UrlFactory;
import io.confluent.rest.annotations.PerformanceMetric;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;

@Path(value="/v3/clusters/{clusterId}/brokers/{brokerId}/tasks")
@ResourceAccesslistFeature.ResourceName(value="api.v3.broker-tasks.*")
public final class BrokerTaskByBrokerResource {
    private final Provider<BrokerTaskManager> brokerTaskManager;
    private final CrnFactory crnFactory;
    private final UrlFactory urlFactory;

    @Inject
    public BrokerTaskByBrokerResource(Provider<BrokerTaskManager> brokerTaskManager, CrnFactory crnFactory, UrlFactory urlFactory) {
        this.brokerTaskManager = Objects.requireNonNull(brokerTaskManager);
        this.crnFactory = Objects.requireNonNull(crnFactory);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @GET
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.brokers.broker-tasks.list")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.brokers.broker-tasks.list")
    public void listBrokerTasksByBroker(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="brokerId") Integer brokerId) {
        CompletionStage response = ((BrokerTaskManager)this.brokerTaskManager.get()).listBrokerTasksByBroker(clusterId, brokerId).thenApply(brokerTasks -> ListBrokerTasksByBrokerResponse.create((BrokerTaskDataList)((BrokerTaskDataList.Builder)((BrokerTaskDataList.Builder)BrokerTaskDataList.builder().setMetadata(ResourceCollection.Metadata.builder().setSelf(this.urlFactory.create(new String[]{"v3", "clusters", clusterId, "brokers", Integer.toString(brokerId), "tasks"})).build())).setData(brokerTasks.stream().map(brokerTask -> BrokerTaskResource.toBrokerTaskData(this.urlFactory, this.crnFactory, brokerTask)).collect(Collectors.toList()))).build()));
        AsyncResponses.asyncResume((AsyncResponse)asyncResponse, (CompletableFuture)response);
    }

    @GET
    @Path(value="/{taskType}")
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.brokers.broker-tasks.search-by-type")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.brokers.broker-tasks.search-by-type")
    public void getBrokerTask(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="brokerId") Integer brokerId, @PathParam(value="taskType") BrokerTaskType taskType) {
        CompletionStage response = ((CompletableFuture)((BrokerTaskManager)this.brokerTaskManager.get()).getBrokerTask(clusterId, brokerId, taskType).thenApply(brokerTask -> (BrokerTask)brokerTask.orElseThrow(NotFoundException::new))).thenApply(brokerTask -> GetBrokerTaskResponse.create(BrokerTaskResource.toBrokerTaskData(this.urlFactory, this.crnFactory, brokerTask)));
        AsyncResponses.asyncResume((AsyncResponse)asyncResponse, (CompletableFuture)response);
    }
}

