/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.RemoveBrokerTaskManager;
import io.confluent.kafkarest.entities.RemoveBrokerTask;
import io.confluent.kafkarest.entities.v3.GetRemoveBrokerTaskResponse;
import io.confluent.kafkarest.entities.v3.ListRemoveBrokerTaskResponse;
import io.confluent.kafkarest.entities.v3.RemoveBrokerTaskData;
import io.confluent.kafkarest.entities.v3.RemoveBrokerTaskDataList;
import io.confluent.kafkarest.entities.v3.Resource;
import io.confluent.kafkarest.entities.v3.ResourceCollection;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.response.CrnFactory;
import io.confluent.kafkarest.response.UrlFactory;
import io.confluent.rest.annotations.PerformanceMetric;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;

@Path(value="/v3/clusters/{clusterId}/remove-broker-tasks")
@ResourceAccesslistFeature.ResourceName(value="api.v3.broker-tasks.*")
public final class RemoveBrokerTaskResource {
    private final Provider<RemoveBrokerTaskManager> removeBrokerTaskManager;
    private final CrnFactory crnFactory;
    private final UrlFactory urlFactory;

    @Inject
    public RemoveBrokerTaskResource(Provider<RemoveBrokerTaskManager> removeBrokerTaskManager, CrnFactory crnFactory, UrlFactory urlFactory) {
        this.removeBrokerTaskManager = Objects.requireNonNull(removeBrokerTaskManager);
        this.crnFactory = Objects.requireNonNull(crnFactory);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @GET
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.broker-tasks.remove-broker.list")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.broker-tasks.remove-broker.list")
    public void listRemoveBrokerTasks(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId) {
        CompletionStage response = ((RemoveBrokerTaskManager)this.removeBrokerTaskManager.get()).listRemoveBrokerTasks(clusterId).thenApply(removeBrokerTasks -> ListRemoveBrokerTaskResponse.create((RemoveBrokerTaskDataList)((RemoveBrokerTaskDataList.Builder)((RemoveBrokerTaskDataList.Builder)RemoveBrokerTaskDataList.builder().setMetadata(ResourceCollection.Metadata.builder().setSelf(this.urlFactory.create(new String[]{"v3", "clusters", clusterId, "remove-broker-tasks"})).build())).setData(removeBrokerTasks.stream().map(this::toRemoveBrokerTaskData).collect(Collectors.toList()))).build()));
        AsyncResponses.asyncResume((AsyncResponse)asyncResponse, (CompletableFuture)response);
    }

    @GET
    @Path(value="/{brokerId}")
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.broker-tasks.remove-broker.get")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.broker-tasks.remove-broker.get")
    public void getRemoveBrokerTask(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="brokerId") Integer brokerId) {
        CompletionStage response = ((CompletableFuture)((RemoveBrokerTaskManager)this.removeBrokerTaskManager.get()).getRemoveBrokerTask(clusterId, brokerId).thenApply(removeBrokerTask -> (RemoveBrokerTask)removeBrokerTask.orElseThrow(NotFoundException::new))).thenApply(removeBrokerTask -> GetRemoveBrokerTaskResponse.create(this.toRemoveBrokerTaskData((RemoveBrokerTask)removeBrokerTask)));
        AsyncResponses.asyncResume((AsyncResponse)asyncResponse, (CompletableFuture)response);
    }

    private RemoveBrokerTaskData toRemoveBrokerTaskData(RemoveBrokerTask removeBrokerTask) {
        return ((RemoveBrokerTaskData.Builder)RemoveBrokerTaskData.fromRemoveBrokerTask(removeBrokerTask).setMetadata(Resource.Metadata.builder().setSelf(this.urlFactory.create(new String[]{"v3", "clusters", removeBrokerTask.getClusterId(), "remove-broker-tasks", Integer.toString(removeBrokerTask.getBrokerId())})).setResourceName(this.crnFactory.create(new String[]{"kafka", removeBrokerTask.getClusterId(), "remove-broker-task", Integer.toString(removeBrokerTask.getBrokerId())})).build())).setBroker(Resource.Relationship.create((String)this.urlFactory.create(new String[]{"v3", "clusters", removeBrokerTask.getClusterId(), "brokers", Integer.toString(removeBrokerTask.getBrokerId())}))).build();
    }
}

