/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.Errors;
import io.confluent.kafkarest.controllers.SimpleConsumeManager;
import io.confluent.kafkarest.controllers.TopicManager;
import io.confluent.kafkarest.entities.Partition;
import io.confluent.kafkarest.entities.Topic;
import io.confluent.kafkarest.entities.v3.PartitionConsumeData;
import io.confluent.kafkarest.entities.v3.SimpleConsumeMultiPartitionRequest;
import io.confluent.kafkarest.entities.v3.SimpleConsumeMultiPartitionResponse;
import io.confluent.kafkarest.entities.v3.SimpleConsumeSinglePartitionResponse;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.rest.annotations.PerformanceMetric;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.validation.Valid;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import org.apache.kafka.common.TopicPartition;

@Path(value="/v3/clusters/{clusterId}/internal/topics/{topicName}")
@ResourceAccesslistFeature.ResourceName(value="api.v3.simple-consume.*")
public final class SimpleConsumeAction {
    private final Provider<TopicManager> topicManager;
    private final Provider<SimpleConsumeManager> simpleConsumeManager;

    @Inject
    public SimpleConsumeAction(Provider<TopicManager> topicManager, Provider<SimpleConsumeManager> simpleConsumeManager) {
        this.topicManager = Objects.requireNonNull(topicManager);
        this.simpleConsumeManager = Objects.requireNonNull(simpleConsumeManager);
    }

    @GET
    @Path(value="/partitions/{partitionId}/records")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ResourceAccesslistFeature.ResourceName(value="api.v3.simple-consume.1-partition")
    @PerformanceMetric(value="v3.simple-consume.1-partition")
    public void consumeFromPartition(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="topicName") String topicName, @PathParam(value="partitionId") Integer partitionId, @QueryParam(value="offset") String offsetParam, @QueryParam(value="timestamp") String timestampParam, @QueryParam(value="max_poll_records") Integer maxPollRecords, @QueryParam(value="fetch_max_bytes") Integer fetchMaxBytes) {
        if (offsetParam != null && timestampParam != null || offsetParam == null && timestampParam == null) {
            throw new BadRequestException("Exactly one of 'offset' and 'timestamp' should be provided");
        }
        Long offset = SimpleConsumeAction.validateLongQueryParameter(offsetParam, "offset");
        Long timestamp = SimpleConsumeAction.validateLongQueryParameter(timestampParam, "timestamp");
        SimpleConsumeManager manager = (SimpleConsumeManager)this.simpleConsumeManager.get();
        CompletionStage responseFuture = ((CompletableFuture)this.checkClusterTopicExist(clusterId, topicName).thenCompose(topic -> {
            SimpleConsumeAction.validatePartitions(Collections.singleton(partitionId), (List<Partition>)topic.getPartitions());
            TopicPartition partition = new TopicPartition(topicName, partitionId.intValue());
            return offset != null ? manager.consumeFromPartitionWithOffset(partition, offset, maxPollRecords, fetchMaxBytes) : manager.consumeFromPartitionWithTimestamp(partition, timestamp, maxPollRecords, fetchMaxBytes);
        })).thenApply(singlePartitionRecords -> SimpleConsumeSinglePartitionResponse.builder().setClusterId(clusterId).setTopicName(topicName).setPartitionData((PartitionConsumeData)singlePartitionRecords).build());
        AsyncResponses.asyncResume((AsyncResponse)asyncResponse, (CompletableFuture)responseFuture);
    }

    @POST
    @Path(value="/partitions/-/records:consume")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ResourceAccesslistFeature.ResourceName(value="api.v3.simple-consume.n-partitions")
    @PerformanceMetric(value="v3.simple-consume.n-partitions")
    public void consumeFromPartitions(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="topicName") String topicName, @Valid SimpleConsumeMultiPartitionRequest request) {
        CompletableFuture<SimpleConsumeMultiPartitionResponse> responseFuture = this.doConsumeFromPartitions(clusterId, topicName, request, false);
        AsyncResponses.asyncResume((AsyncResponse)asyncResponse, responseFuture);
    }

    @POST
    @Path(value="/partitions/-/records:consume_guarantee_progress")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ResourceAccesslistFeature.ResourceName(value="api.v3.simple-consume.n-partitions-guarantee-progress")
    @PerformanceMetric(value="v3.simple-consume.n-partitions-guarantee-progress")
    public void consumeFromPartitionsGuaranteeProgress(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="topicName") String topicName, @Valid SimpleConsumeMultiPartitionRequest request) {
        CompletableFuture<SimpleConsumeMultiPartitionResponse> responseFuture = this.doConsumeFromPartitions(clusterId, topicName, request, true);
        AsyncResponses.asyncResume((AsyncResponse)asyncResponse, responseFuture);
    }

    private CompletableFuture<SimpleConsumeMultiPartitionResponse> doConsumeFromPartitions(String clusterId, String topicName, SimpleConsumeMultiPartitionRequest request, boolean guaranteeProgressForEachPartition) {
        if (request == null) {
            throw Errors.invalidPayloadException((String)"Null input provided. Data is required.");
        }
        int positionCriteriaCount = 0;
        if (request.getOffsets() != null) {
            ++positionCriteriaCount;
        }
        if (request.getFromBeginning() != null) {
            ++positionCriteriaCount;
        }
        if (request.getTimestamp() != null) {
            ++positionCriteriaCount;
        }
        if (positionCriteriaCount > 1) {
            throw new BadRequestException("At most one of 'offsets', 'from_beginning' or 'timestamp' should be provided.");
        }
        SimpleConsumeManager manager = (SimpleConsumeManager)this.simpleConsumeManager.get();
        return ((CompletableFuture)this.checkClusterTopicExist(clusterId, topicName).thenCompose(topic -> {
            List<SimpleConsumeMultiPartitionRequest.PartitionOffset> offsetsList = request.getOffsets();
            Map<Integer, Long> offsets = offsetsList != null ? offsetsList.stream().collect(Collectors.toMap(SimpleConsumeMultiPartitionRequest.PartitionOffset::getPartitionId, SimpleConsumeMultiPartitionRequest.PartitionOffset::getOffset)) : null;
            ImmutableList partitions = topic.getPartitions();
            if (offsets != null) {
                SimpleConsumeAction.validatePartitions(offsets.keySet(), (List<Partition>)partitions);
            }
            return manager.consumeFromMultiplePartitions(topicName, partitions.size(), offsets, request.getFromBeginning(), request.getTimestamp(), request.getMaxPollRecords(), request.getFetchMaxBytes(), guaranteeProgressForEachPartition);
        })).thenApply(multiPartitionRecords -> SimpleConsumeMultiPartitionResponse.builder().setClusterId(clusterId).setTopicName(topicName).setPartitionDataList((List<PartitionConsumeData>)multiPartitionRecords).build());
    }

    private CompletableFuture<Topic> checkClusterTopicExist(String clusterId, String topicName) {
        return ((TopicManager)this.topicManager.get()).getTopic(clusterId, topicName).thenApply(topic -> (Topic)topic.orElseThrow(Errors::topicNotFoundException));
    }

    private static void validatePartitions(@Nonnull Set<Integer> requested, @Nonnull List<Partition> available) {
        Map<Integer, Partition> availableById = available.stream().collect(Collectors.toMap(Partition::getPartitionId, p -> p));
        for (int requestedId : requested) {
            if (availableById.containsKey(requestedId)) continue;
            throw new BadRequestException("Cannot find partition with ID " + requestedId);
        }
    }

    private static Long validateLongQueryParameter(String paramValue, String paramName) {
        if (paramValue != null) {
            try {
                return Long.valueOf(paramValue);
            }
            catch (NumberFormatException nfe) {
                throw new BadRequestException("'" + paramName + "' must be numeric");
            }
        }
        return null;
    }
}

