/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.support.metrics;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.kafka.common.config.ConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSupportConfig {
    private static final Logger log = LoggerFactory.getLogger(BaseSupportConfig.class);
    static final String CONFLUENT_PHONE_HOME_ENDPOINT_BASE_SECURE = "https://version-check.confluent.io";
    static final String CONFLUENT_PHONE_HOME_ENDPOINT_BASE_INSECURE = "http://version-check.confluent.io";
    public static final String CONFLUENT_PHONE_HOME_ENDPOINT_SUFFIX_USER_ANON = "anon";
    public static final String CONFLUENT_PHONE_HOME_ENDPOINT_SUFFIX_USER_TEST = "test";
    public static final String CONFLUENT_PHONE_HOME_ENDPOINT_SUFFIX_USER_CUSTOMER = "submit";
    public static final String CONFLUENT_SUPPORT_METRICS_ENABLE_CONFIG = "confluent.support.metrics.enable";
    private static final String CONFLUENT_SUPPORT_METRICS_ENABLE_DOC = "False to disable metric collection, true otherwise.";
    public static final String CONFLUENT_SUPPORT_METRICS_ENABLE_DEFAULT = "true";
    public static final String CONFLUENT_SUPPORT_CUSTOMER_ID_CONFIG = "confluent.support.customer.id";
    private static final String CONFLUENT_SUPPORT_CUSTOMER_ID_DOC = "Customer ID assigned by Confluent";
    public static final String CONFLUENT_SUPPORT_CUSTOMER_ID_DEFAULT = "anonymous";
    public static final String CONFLUENT_SUPPORT_TEST_ID_DEFAULT = "c0";
    public static final String CONFLUENT_SUPPORT_METRICS_REPORT_INTERVAL_HOURS_CONFIG = "confluent.support.metrics.report.interval.hours";
    private static final String CONFLUENT_SUPPORT_METRICS_REPORT_INTERVAL_HOURS_DOC = "Frequency of reporting in hours, e.g., 24 would indicate every day ";
    public static final String CONFLUENT_SUPPORT_METRICS_REPORT_INTERVAL_HOURS_DEFAULT = "24";
    public static final String CONFLUENT_SUPPORT_METRICS_ENDPOINT_INSECURE_ENABLE_CONFIG = "confluent.support.metrics.endpoint.insecure.enable";
    public static final String CONFLUENT_SUPPORT_METRICS_ENDPOINT_INSECURE_ENABLE_DOC = "False to disable reporting over HTTP, true otherwise";
    public static final String CONFLUENT_SUPPORT_METRICS_ENDPOINT_INSECURE_ENABLE_DEFAULT = "true";
    public static final String CONFLUENT_SUPPORT_METRICS_ENDPOINT_SECURE_ENABLE_CONFIG = "confluent.support.metrics.endpoint.secure.enable";
    public static final String CONFLUENT_SUPPORT_METRICS_ENDPOINT_SECURE_ENABLE_DOC = "False to disable reporting over HTTPS, true otherwise";
    public static final String CONFLUENT_SUPPORT_METRICS_ENDPOINT_SECURE_ENABLE_DEFAULT = "true";
    public static final String CONFLUENT_SUPPORT_PROXY_CONFIG = "confluent.support.proxy";
    public static final String CONFLUENT_SUPPORT_PROXY_DOC = "HTTP forward proxy used to support metrics to Confluent";
    public static final String CONFLUENT_SUPPORT_PROXY_DEFAULT = "";
    public static final String CONFLUENT_SUPPORT_METRICS_ENDPOINT_INSECURE_CONFIG = "confluent.support.metrics.endpoint.insecure";
    public static final String CONFLUENT_SUPPORT_METRICS_ENDPOINT_SECURE_CONFIG = "confluent.support.metrics.endpoint.secure";
    private static final Pattern CUSTOMER_PATTERN = Pattern.compile("c\\d{1,30}");
    private static final Pattern NEW_CUSTOMER_CASE_SENSISTIVE_PATTERN = Pattern.compile("[a-zA-Z0-9]{15}");
    private static final Pattern NEW_CUSTOMER_CASE_INSENSISTIVE_PATTERN = Pattern.compile("[a-zA-Z0-9]{18}");
    private Properties properties;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public Properties getProperties() {
        return this.properties;
    }

    protected Properties getDefaultProps() {
        Properties props = new Properties();
        props.setProperty(CONFLUENT_SUPPORT_METRICS_ENABLE_CONFIG, "true");
        props.setProperty(CONFLUENT_SUPPORT_CUSTOMER_ID_CONFIG, CONFLUENT_SUPPORT_CUSTOMER_ID_DEFAULT);
        props.setProperty(CONFLUENT_SUPPORT_METRICS_REPORT_INTERVAL_HOURS_CONFIG, CONFLUENT_SUPPORT_METRICS_REPORT_INTERVAL_HOURS_DEFAULT);
        props.setProperty(CONFLUENT_SUPPORT_METRICS_ENDPOINT_INSECURE_ENABLE_CONFIG, "true");
        props.setProperty(CONFLUENT_SUPPORT_METRICS_ENDPOINT_SECURE_ENABLE_CONFIG, "true");
        props.setProperty(CONFLUENT_SUPPORT_PROXY_CONFIG, CONFLUENT_SUPPORT_PROXY_DEFAULT);
        return props;
    }

    public BaseSupportConfig(Properties originals) {
        this.mergeAndValidateWithDefaultProperties(originals, null);
    }

    public BaseSupportConfig(Properties originals, String endpointPath) {
        this.mergeAndValidateWithDefaultProperties(originals, endpointPath);
    }

    private void mergeAndValidateWithDefaultProperties(Properties overrides, String endpointPath) {
        Properties props;
        Properties defaults = this.getDefaultProps();
        if (overrides == null) {
            props = defaults;
        } else {
            props = new Properties();
            props.putAll((Map<?, ?>)defaults);
            props.putAll((Map<?, ?>)overrides);
        }
        this.properties = props;
        props.remove(CONFLUENT_SUPPORT_METRICS_ENDPOINT_INSECURE_CONFIG);
        props.remove(CONFLUENT_SUPPORT_METRICS_ENDPOINT_SECURE_CONFIG);
        String customerId = this.getCustomerId();
        if (endpointPath != null) {
            if (this.isHttpEnabled()) {
                this.setEndpointHttp(BaseSupportConfig.getEndpoint(false, customerId, endpointPath));
            }
            if (this.isHttpsEnabled()) {
                this.setEndpointHttps(BaseSupportConfig.getEndpoint(true, customerId, endpointPath));
            }
        } else {
            this.setEndpointsOldWay(customerId);
        }
    }

    private void setEndpointsOldWay(String customerId) {
        if (BaseSupportConfig.isAnonymousUser(customerId)) {
            if (this.isHttpEnabled()) {
                this.setEndpointHttp(this.getAnonymousEndpoint(false));
            }
            if (this.isHttpsEnabled()) {
                this.setEndpointHttps(this.getAnonymousEndpoint(true));
            }
        } else if (BaseSupportConfig.isTestUser(customerId)) {
            if (this.isHttpEnabled()) {
                this.setEndpointHttp(this.getTestEndpoint(false));
            }
            if (this.isHttpsEnabled()) {
                this.setEndpointHttps(this.getTestEndpoint(true));
            }
        } else {
            if (this.isHttpEnabled()) {
                this.setEndpointHttp(this.getCustomerEndpoint(false));
            }
            if (this.isHttpsEnabled()) {
                this.setEndpointHttps(this.getCustomerEndpoint(true));
            }
        }
    }

    protected String getAnonymousEndpoint(boolean secure) {
        return null;
    }

    protected String getTestEndpoint(boolean secure) {
        return null;
    }

    protected String getCustomerEndpoint(boolean secure) {
        return null;
    }

    public static String getEndpoint(boolean secure, String customerId, String endpointPath) {
        String base = secure ? CONFLUENT_PHONE_HOME_ENDPOINT_BASE_SECURE : CONFLUENT_PHONE_HOME_ENDPOINT_BASE_INSECURE;
        return base + "/" + endpointPath + "/" + BaseSupportConfig.getEndpointSuffix(customerId);
    }

    private static String getEndpointSuffix(String customerId) {
        if (BaseSupportConfig.isAnonymousUser(customerId)) {
            return CONFLUENT_PHONE_HOME_ENDPOINT_SUFFIX_USER_ANON;
        }
        if (BaseSupportConfig.isTestUser(customerId)) {
            return CONFLUENT_PHONE_HOME_ENDPOINT_SUFFIX_USER_TEST;
        }
        return CONFLUENT_PHONE_HOME_ENDPOINT_SUFFIX_USER_CUSTOMER;
    }

    public boolean isProactiveSupportEnabled() {
        if (this.properties == null) {
            return false;
        }
        return this.getMetricsEnabled();
    }

    public static boolean isAnonymousUser(String customerId) {
        return customerId != null && customerId.toLowerCase(Locale.ROOT).equals(CONFLUENT_SUPPORT_CUSTOMER_ID_DEFAULT);
    }

    public static boolean isTestUser(String customerId) {
        return customerId != null && customerId.toLowerCase(Locale.ROOT).equals(CONFLUENT_SUPPORT_TEST_ID_DEFAULT);
    }

    public static boolean isConfluentCustomer(String customerId) {
        return customerId != null && (CUSTOMER_PATTERN.matcher(customerId.toLowerCase(Locale.ROOT)).matches() || NEW_CUSTOMER_CASE_INSENSISTIVE_PATTERN.matcher(customerId).matches() || NEW_CUSTOMER_CASE_SENSISTIVE_PATTERN.matcher(customerId).matches());
    }

    public static boolean isSyntacticallyCorrectCustomerId(String customerId) {
        return BaseSupportConfig.isAnonymousUser(customerId) || BaseSupportConfig.isConfluentCustomer(customerId);
    }

    public static boolean isCaseSensitiveCustomerId(String customerId) {
        return NEW_CUSTOMER_CASE_SENSISTIVE_PATTERN.matcher(customerId).matches();
    }

    public String getCustomerId() {
        return BaseSupportConfig.getCustomerId(this.properties);
    }

    public static String getCustomerId(Properties props) {
        String fallbackId = CONFLUENT_SUPPORT_CUSTOMER_ID_DEFAULT;
        String id = props.getProperty(CONFLUENT_SUPPORT_CUSTOMER_ID_CONFIG);
        if (id == null || id.isEmpty()) {
            log.info("No customer ID configured -- falling back to id '{}'", (Object)CONFLUENT_SUPPORT_CUSTOMER_ID_DEFAULT);
            id = CONFLUENT_SUPPORT_CUSTOMER_ID_DEFAULT;
        }
        if (!BaseSupportConfig.isSyntacticallyCorrectCustomerId(id)) {
            log.error("'{}' is not a valid Confluent customer ID -- falling back to id '{}'", (Object)id, (Object)CONFLUENT_SUPPORT_CUSTOMER_ID_DEFAULT);
            id = CONFLUENT_SUPPORT_CUSTOMER_ID_DEFAULT;
        }
        return id;
    }

    public long getReportIntervalMs() {
        String intervalString = this.properties.getProperty(CONFLUENT_SUPPORT_METRICS_REPORT_INTERVAL_HOURS_CONFIG);
        if (intervalString == null || intervalString.isEmpty()) {
            intervalString = CONFLUENT_SUPPORT_METRICS_REPORT_INTERVAL_HOURS_DEFAULT;
        }
        try {
            long intervalHours = Long.parseLong(intervalString);
            if (intervalHours < 1L) {
                throw new ConfigException(CONFLUENT_SUPPORT_METRICS_REPORT_INTERVAL_HOURS_CONFIG, (Object)intervalString, "Interval must be >= 1");
            }
            return intervalHours * 60L * 60L * 1000L;
        }
        catch (NumberFormatException e) {
            throw new ConfigException(CONFLUENT_SUPPORT_METRICS_REPORT_INTERVAL_HOURS_CONFIG, (Object)intervalString, "Interval is not an integer number");
        }
    }

    public boolean getMetricsEnabled() {
        String enableString = this.properties.getProperty(CONFLUENT_SUPPORT_METRICS_ENABLE_CONFIG, "false");
        return Boolean.parseBoolean(enableString);
    }

    public boolean isHttpEnabled() {
        String enableHttp = this.properties.getProperty(CONFLUENT_SUPPORT_METRICS_ENDPOINT_INSECURE_ENABLE_CONFIG, "true");
        return Boolean.parseBoolean(enableHttp);
    }

    public String getEndpointHttp() {
        return this.properties.getProperty(CONFLUENT_SUPPORT_METRICS_ENDPOINT_INSECURE_CONFIG, CONFLUENT_SUPPORT_PROXY_DEFAULT);
    }

    public void setEndpointHttp(String endpointHttp) {
        this.properties.setProperty(CONFLUENT_SUPPORT_METRICS_ENDPOINT_INSECURE_CONFIG, endpointHttp);
    }

    public boolean isHttpsEnabled() {
        String enableHttps = this.properties.getProperty(CONFLUENT_SUPPORT_METRICS_ENDPOINT_SECURE_ENABLE_CONFIG, "true");
        return Boolean.parseBoolean(enableHttps);
    }

    public String getEndpointHttps() {
        return this.properties.getProperty(CONFLUENT_SUPPORT_METRICS_ENDPOINT_SECURE_CONFIG, CONFLUENT_SUPPORT_PROXY_DEFAULT);
    }

    public void setEndpointHttps(String endpointHttps) {
        this.properties.setProperty(CONFLUENT_SUPPORT_METRICS_ENDPOINT_SECURE_CONFIG, endpointHttps);
    }

    public String getProxy() {
        return this.properties.getProperty(CONFLUENT_SUPPORT_PROXY_CONFIG, CONFLUENT_SUPPORT_PROXY_DEFAULT);
    }
}

