/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.pluginregistry.rest.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.confluent.pluginregistry.OwnerType;
import io.confluent.pluginregistry.util.JsonUtil;
import io.confluent.pluginregistry.util.ObjectUtil;
import java.io.IOException;

@JsonPropertyOrder(value={"username", "type", "name", "url", "logo"})
public class PluginOwner
implements Comparable<PluginOwner> {
    @JsonProperty
    private String username;
    @JsonProperty
    private OwnerType type;
    @JsonProperty
    private String name;
    @JsonProperty
    private String url;
    @JsonProperty
    private String logo;

    public static PluginOwner fromJson(String json) throws IOException {
        return (PluginOwner)JsonUtil.newObjectMapper().readValue(json, PluginOwner.class);
    }

    public PluginOwner() {
    }

    public PluginOwner(String username, OwnerType type, String name, String url, String logo) {
        this.username = username;
        this.type = type;
        this.name = name;
        this.url = url;
        this.logo = logo;
    }

    public PluginOwner(PluginOwner original) {
        this.username = original.username;
        this.type = original.type;
        this.name = original.name;
        this.url = original.url;
        this.logo = original.logo;
    }

    public String toJson() throws IOException {
        return JsonUtil.newObjectMapper().writeValueAsString((Object)this);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public OwnerType getType() {
        return this.type;
    }

    public void setType(OwnerType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getLogo() {
        return this.logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public int hashCode() {
        return this.username != null ? this.username.hashCode() : 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginOwner that = (PluginOwner)o;
        return ObjectUtil.equals(this.username, that.username) && ObjectUtil.equals((Object)this.type, (Object)that.type) && ObjectUtil.equals(this.name, that.name) && ObjectUtil.equals(this.url, that.url) && ObjectUtil.equals(this.logo, that.logo);
    }

    @Override
    public int compareTo(PluginOwner that) {
        if (this == that) {
            return 0;
        }
        if (that == null) {
            return 1;
        }
        return ObjectUtil.compareTo(this.username, that.username);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{username=" + this.username + ",");
        sb.append("type=" + (Object)((Object)this.type) + ",");
        sb.append("name=" + this.name + ",");
        sb.append("url=" + this.url + ",");
        sb.append("logo=" + this.logo + "}");
        return sb.toString();
    }
}

