/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.serde.StaticTopicSerde;
import io.confluent.ksql.util.KsqlConstants;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RegisterSchemaCallback
implements StaticTopicSerde.Callback {
    private static final Logger LOG = LoggerFactory.getLogger(RegisterSchemaCallback.class);
    private final SchemaRegistryClient srClient;
    private final Set<SchemaRegisterEvent> failedAttempts = new HashSet<SchemaRegisterEvent>();

    RegisterSchemaCallback(SchemaRegistryClient srClient) {
        this.srClient = Objects.requireNonNull(srClient, "srClient");
    }

    public void onDeserializationFailure(String source, String changelog, byte[] data) {
        String sourceSubject = KsqlConstants.getSRSubject((String)source, (boolean)false);
        String changelogSubject = KsqlConstants.getSRSubject((String)changelog, (boolean)false);
        int id = ByteBuffer.wrap(data, 1, 4).getInt();
        SchemaRegisterEvent event = new SchemaRegisterEvent(id, sourceSubject, changelogSubject);
        try {
            if (!this.failedAttempts.contains(event)) {
                LOG.info("Trying to fetch & register schema id {} under subject {}", (Object)id, (Object)changelogSubject);
                ParsedSchema schema = this.srClient.getSchemaBySubjectAndId(sourceSubject, id);
                this.srClient.register(changelogSubject, schema);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed during deserialization callback for topic {}. Will not try again to register id {} under subject {}.", new Object[]{source, id, changelogSubject, e});
            this.failedAttempts.add(event);
        }
    }

    private static final class SchemaRegisterEvent {
        final int id;
        final String sourceSubject;
        final String changelogSubject;

        private SchemaRegisterEvent(int id, String sourceSubject, String changelogSubject) {
            this.id = id;
            this.sourceSubject = sourceSubject;
            this.changelogSubject = changelogSubject;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SchemaRegisterEvent that = (SchemaRegisterEvent)o;
            return this.id == that.id && Objects.equals(this.sourceSubject, that.sourceSubject) && Objects.equals(this.changelogSubject, that.changelogSubject);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.sourceSubject, this.changelogSubject);
        }
    }
}

