/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.streams.RoutingOptions;
import io.confluent.ksql.util.KsqlHostInfo;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.streams.state.HostInfo;

public interface RoutingFilter {
    public Host filter(KsqlHostInfo var1);

    public static interface RoutingFilterFactory {
        public RoutingFilter createRoutingFilter(RoutingOptions var1, List<KsqlHostInfo> var2, HostInfo var3, String var4, String var5, int var6);
    }

    @Immutable
    public static class Host {
        private final KsqlHostInfo sourceInfo;
        private final boolean selected;
        private final String reasonNotSelected;

        private Host(KsqlHostInfo sourceInfo, boolean selected, String reasonNotSelected) {
            this.sourceInfo = Objects.requireNonNull(sourceInfo, "sourceInfo");
            this.selected = selected;
            this.reasonNotSelected = Objects.requireNonNull(reasonNotSelected, "reasonNotSelected");
        }

        public static Host include(KsqlHostInfo host) {
            return new Host(host, true, "");
        }

        public static Host exclude(KsqlHostInfo host, String reason) {
            return new Host(host, false, reason);
        }

        public KsqlHostInfo getSourceInfo() {
            return this.sourceInfo;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public String getReasonNotSelected() {
            return this.reasonNotSelected;
        }

        public Host combine(Host other) {
            if (!this.sourceInfo.equals((Object)other.sourceInfo)) {
                throw new IllegalStateException("Should not combine non-matching hosts");
            }
            return new Host(this.sourceInfo, this.selected && other.selected, Stream.of(this.reasonNotSelected, other.reasonNotSelected).filter(s -> !s.isEmpty()).collect(Collectors.joining(",")));
        }

        public String toString() {
            return this.sourceInfo + " was " + (this.selected ? "selected" : "not selected because " + this.reasonNotSelected);
        }
    }
}

