/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams;

import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.materialization.MaterializationInfo;
import io.confluent.ksql.execution.plan.ExecutionKeyFactory;
import io.confluent.ksql.execution.plan.KTableHolder;
import io.confluent.ksql.execution.plan.PlanInfo;
import io.confluent.ksql.execution.plan.SourceStep;
import io.confluent.ksql.execution.runtime.MaterializedFactory;
import io.confluent.ksql.execution.runtime.RuntimeBuildContext;
import io.confluent.ksql.execution.streams.ConsumedFactory;
import io.confluent.ksql.execution.streams.SourceBuilderUtils;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.PhysicalSchema;
import java.util.Collection;
import java.util.function.Function;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.state.KeyValueStore;

abstract class SourceBuilderBase {
    SourceBuilderBase() {
    }

    KTableHolder<GenericKey> buildTable(RuntimeBuildContext buildContext, SourceStep<KTableHolder<GenericKey>> source, ConsumedFactory consumedFactory, MaterializedFactory materializedFactory, PlanInfo planInfo) {
        PhysicalSchema physicalSchema = SourceBuilderUtils.getPhysicalSchema(source);
        Serde<GenericRow> valueSerde = SourceBuilderUtils.getValueSerde(buildContext, source, physicalSchema);
        Serde<GenericKey> keySerde = SourceBuilderUtils.getKeySerde(source, physicalSchema, buildContext);
        Consumed<GenericKey, GenericRow> consumed = SourceBuilderUtils.buildSourceConsumed(source, keySerde, valueSerde, Topology.AutoOffsetReset.EARLIEST, buildContext, consumedFactory);
        String stateStoreName = SourceBuilderUtils.tableChangeLogOpName(source.getProperties());
        Materialized<GenericKey, GenericRow, KeyValueStore<Bytes, byte[]>> materialized = this.buildTableMaterialized(source, buildContext, materializedFactory, keySerde, valueSerde, stateStoreName);
        KTable<GenericKey, GenericRow> ktable = this.buildKTable(source, buildContext, consumed, GenericKey::values, materialized, valueSerde, stateStoreName, planInfo);
        LogicalSchema stateStoreSchema = source.getSourceSchema().withPseudoColumnsToMaterialize(source.getPseudoColumnVersion());
        return KTableHolder.materialized(ktable, (LogicalSchema)SourceBuilderUtils.buildSchema(source, false), (ExecutionKeyFactory)ExecutionKeyFactory.unwindowed((RuntimeBuildContext)buildContext), (MaterializationInfo.Builder)MaterializationInfo.builder((String)stateStoreName, (LogicalSchema)stateStoreSchema));
    }

    abstract Materialized<GenericKey, GenericRow, KeyValueStore<Bytes, byte[]>> buildTableMaterialized(SourceStep<KTableHolder<GenericKey>> var1, RuntimeBuildContext var2, MaterializedFactory var3, Serde<GenericKey> var4, Serde<GenericRow> var5, String var6);

    abstract <K> KTable<K, GenericRow> buildKTable(SourceStep<?> var1, RuntimeBuildContext var2, Consumed<K, GenericRow> var3, Function<K, Collection<?>> var4, Materialized<K, GenericRow, KeyValueStore<Bytes, byte[]>> var5, Serde<GenericRow> var6, String var7, PlanInfo var8);
}

